/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class CreateOTAVerifyJobRequest
extends Request {
    @Query
    @NameInMap(value="DownloadProtocol")
    private String downloadProtocol;
    @Query
    @NameInMap(value="FirmwareId")
    @Validation(required=true)
    private String firmwareId;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="NeedConfirm")
    private Boolean needConfirm;
    @Query
    @NameInMap(value="NeedPush")
    private Boolean needPush;
    @Query
    @NameInMap(value="ProductKey")
    @Validation(required=true)
    private String productKey;
    @Query
    @NameInMap(value="Tag")
    private List<Tag> tag;
    @Query
    @NameInMap(value="TargetDeviceName")
    @Validation(required=true)
    private List<String> targetDeviceName;
    @Query
    @NameInMap(value="TimeoutInMinutes")
    private Integer timeoutInMinutes;

    private CreateOTAVerifyJobRequest(Builder builder) {
        super((Request.Builder)builder);
        this.downloadProtocol = builder.downloadProtocol;
        this.firmwareId = builder.firmwareId;
        this.iotInstanceId = builder.iotInstanceId;
        this.needConfirm = builder.needConfirm;
        this.needPush = builder.needPush;
        this.productKey = builder.productKey;
        this.tag = builder.tag;
        this.targetDeviceName = builder.targetDeviceName;
        this.timeoutInMinutes = builder.timeoutInMinutes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateOTAVerifyJobRequest create() {
        return CreateOTAVerifyJobRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getDownloadProtocol() {
        return this.downloadProtocol;
    }

    public String getFirmwareId() {
        return this.firmwareId;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public Boolean getNeedConfirm() {
        return this.needConfirm;
    }

    public Boolean getNeedPush() {
        return this.needPush;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public List<Tag> getTag() {
        return this.tag;
    }

    public List<String> getTargetDeviceName() {
        return this.targetDeviceName;
    }

    public Integer getTimeoutInMinutes() {
        return this.timeoutInMinutes;
    }

    public static class Tag
    extends TeaModel {
        @NameInMap(value="Key")
        @Validation(required=true)
        private String key;
        @NameInMap(value="Value")
        @Validation(required=true)
        private String value;

        private Tag(Builder builder) {
            this.key = builder.key;
            this.value = builder.value;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Tag create() {
            return Tag.builder().build();
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public static final class Builder {
            private String key;
            private String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public Tag build() {
                return new Tag(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<CreateOTAVerifyJobRequest, Builder> {
        private String downloadProtocol;
        private String firmwareId;
        private String iotInstanceId;
        private Boolean needConfirm;
        private Boolean needPush;
        private String productKey;
        private List<Tag> tag;
        private List<String> targetDeviceName;
        private Integer timeoutInMinutes;

        private Builder() {
        }

        private Builder(CreateOTAVerifyJobRequest request) {
            super((Request)request);
            this.downloadProtocol = request.downloadProtocol;
            this.firmwareId = request.firmwareId;
            this.iotInstanceId = request.iotInstanceId;
            this.needConfirm = request.needConfirm;
            this.needPush = request.needPush;
            this.productKey = request.productKey;
            this.tag = request.tag;
            this.targetDeviceName = request.targetDeviceName;
            this.timeoutInMinutes = request.timeoutInMinutes;
        }

        public Builder downloadProtocol(String downloadProtocol) {
            this.putQueryParameter("DownloadProtocol", downloadProtocol);
            this.downloadProtocol = downloadProtocol;
            return this;
        }

        public Builder firmwareId(String firmwareId) {
            this.putQueryParameter("FirmwareId", firmwareId);
            this.firmwareId = firmwareId;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder needConfirm(Boolean needConfirm) {
            this.putQueryParameter("NeedConfirm", needConfirm);
            this.needConfirm = needConfirm;
            return this;
        }

        public Builder needPush(Boolean needPush) {
            this.putQueryParameter("NeedPush", needPush);
            this.needPush = needPush;
            return this;
        }

        public Builder productKey(String productKey) {
            this.putQueryParameter("ProductKey", productKey);
            this.productKey = productKey;
            return this;
        }

        public Builder tag(List<Tag> tag) {
            this.putQueryParameter("Tag", tag);
            this.tag = tag;
            return this;
        }

        public Builder targetDeviceName(List<String> targetDeviceName) {
            this.putQueryParameter("TargetDeviceName", targetDeviceName);
            this.targetDeviceName = targetDeviceName;
            return this;
        }

        public Builder timeoutInMinutes(Integer timeoutInMinutes) {
            this.putQueryParameter("TimeoutInMinutes", timeoutInMinutes);
            this.timeoutInMinutes = timeoutInMinutes;
            return this;
        }

        public CreateOTAVerifyJobRequest build() {
            return new CreateOTAVerifyJobRequest(this);
        }
    }
}

