/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class CreateProductDistributeJobRequest
extends Request {
    @Query
    @NameInMap(value="ProductKey")
    @Validation(required=true)
    private String productKey;
    @Query
    @NameInMap(value="SourceInstanceId")
    @Validation(required=true)
    private String sourceInstanceId;
    @Query
    @NameInMap(value="TargetAliyunId")
    private String targetAliyunId;
    @Query
    @NameInMap(value="TargetInstanceId")
    @Validation(required=true)
    private String targetInstanceId;
    @Query
    @NameInMap(value="TargetUid")
    private String targetUid;

    private CreateProductDistributeJobRequest(Builder builder) {
        super((Request.Builder)builder);
        this.productKey = builder.productKey;
        this.sourceInstanceId = builder.sourceInstanceId;
        this.targetAliyunId = builder.targetAliyunId;
        this.targetInstanceId = builder.targetInstanceId;
        this.targetUid = builder.targetUid;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateProductDistributeJobRequest create() {
        return CreateProductDistributeJobRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getProductKey() {
        return this.productKey;
    }

    public String getSourceInstanceId() {
        return this.sourceInstanceId;
    }

    public String getTargetAliyunId() {
        return this.targetAliyunId;
    }

    public String getTargetInstanceId() {
        return this.targetInstanceId;
    }

    public String getTargetUid() {
        return this.targetUid;
    }

    public static final class Builder
    extends Request.Builder<CreateProductDistributeJobRequest, Builder> {
        private String productKey;
        private String sourceInstanceId;
        private String targetAliyunId;
        private String targetInstanceId;
        private String targetUid;

        private Builder() {
        }

        private Builder(CreateProductDistributeJobRequest request) {
            super((Request)request);
            this.productKey = request.productKey;
            this.sourceInstanceId = request.sourceInstanceId;
            this.targetAliyunId = request.targetAliyunId;
            this.targetInstanceId = request.targetInstanceId;
            this.targetUid = request.targetUid;
        }

        public Builder productKey(String productKey) {
            this.putQueryParameter("ProductKey", productKey);
            this.productKey = productKey;
            return this;
        }

        public Builder sourceInstanceId(String sourceInstanceId) {
            this.putQueryParameter("SourceInstanceId", sourceInstanceId);
            this.sourceInstanceId = sourceInstanceId;
            return this;
        }

        public Builder targetAliyunId(String targetAliyunId) {
            this.putQueryParameter("TargetAliyunId", targetAliyunId);
            this.targetAliyunId = targetAliyunId;
            return this;
        }

        public Builder targetInstanceId(String targetInstanceId) {
            this.putQueryParameter("TargetInstanceId", targetInstanceId);
            this.targetInstanceId = targetInstanceId;
            return this;
        }

        public Builder targetUid(String targetUid) {
            this.putQueryParameter("TargetUid", targetUid);
            this.targetUid = targetUid;
            return this;
        }

        public CreateProductDistributeJobRequest build() {
            return new CreateProductDistributeJobRequest(this);
        }
    }
}

