/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class CreateRuleRequest
extends Request {
    @Query
    @NameInMap(value="DataType")
    private String dataType;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="Name")
    @Validation(required=true)
    private String name;
    @Query
    @NameInMap(value="ProductKey")
    private String productKey;
    @Query
    @NameInMap(value="ResourceGroupId")
    private String resourceGroupId;
    @Query
    @NameInMap(value="RuleDesc")
    private String ruleDesc;
    @Query
    @NameInMap(value="Select")
    private String select;
    @Query
    @NameInMap(value="ShortTopic")
    private String shortTopic;
    @Query
    @NameInMap(value="Topic")
    private String topic;
    @Query
    @NameInMap(value="TopicType")
    private Integer topicType;
    @Query
    @NameInMap(value="Where")
    private String where;

    private CreateRuleRequest(Builder builder) {
        super((Request.Builder)builder);
        this.dataType = builder.dataType;
        this.iotInstanceId = builder.iotInstanceId;
        this.name = builder.name;
        this.productKey = builder.productKey;
        this.resourceGroupId = builder.resourceGroupId;
        this.ruleDesc = builder.ruleDesc;
        this.select = builder.select;
        this.shortTopic = builder.shortTopic;
        this.topic = builder.topic;
        this.topicType = builder.topicType;
        this.where = builder.where;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateRuleRequest create() {
        return CreateRuleRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getName() {
        return this.name;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public String getResourceGroupId() {
        return this.resourceGroupId;
    }

    public String getRuleDesc() {
        return this.ruleDesc;
    }

    public String getSelect() {
        return this.select;
    }

    public String getShortTopic() {
        return this.shortTopic;
    }

    public String getTopic() {
        return this.topic;
    }

    public Integer getTopicType() {
        return this.topicType;
    }

    public String getWhere() {
        return this.where;
    }

    public static final class Builder
    extends Request.Builder<CreateRuleRequest, Builder> {
        private String dataType;
        private String iotInstanceId;
        private String name;
        private String productKey;
        private String resourceGroupId;
        private String ruleDesc;
        private String select;
        private String shortTopic;
        private String topic;
        private Integer topicType;
        private String where;

        private Builder() {
        }

        private Builder(CreateRuleRequest request) {
            super((Request)request);
            this.dataType = request.dataType;
            this.iotInstanceId = request.iotInstanceId;
            this.name = request.name;
            this.productKey = request.productKey;
            this.resourceGroupId = request.resourceGroupId;
            this.ruleDesc = request.ruleDesc;
            this.select = request.select;
            this.shortTopic = request.shortTopic;
            this.topic = request.topic;
            this.topicType = request.topicType;
            this.where = request.where;
        }

        public Builder dataType(String dataType) {
            this.putQueryParameter("DataType", dataType);
            this.dataType = dataType;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder name(String name) {
            this.putQueryParameter("Name", name);
            this.name = name;
            return this;
        }

        public Builder productKey(String productKey) {
            this.putQueryParameter("ProductKey", productKey);
            this.productKey = productKey;
            return this;
        }

        public Builder resourceGroupId(String resourceGroupId) {
            this.putQueryParameter("ResourceGroupId", resourceGroupId);
            this.resourceGroupId = resourceGroupId;
            return this;
        }

        public Builder ruleDesc(String ruleDesc) {
            this.putQueryParameter("RuleDesc", ruleDesc);
            this.ruleDesc = ruleDesc;
            return this;
        }

        public Builder select(String select) {
            this.putQueryParameter("Select", select);
            this.select = select;
            return this;
        }

        public Builder shortTopic(String shortTopic) {
            this.putQueryParameter("ShortTopic", shortTopic);
            this.shortTopic = shortTopic;
            return this;
        }

        public Builder topic(String topic) {
            this.putQueryParameter("Topic", topic);
            this.topic = topic;
            return this;
        }

        public Builder topicType(Integer topicType) {
            this.putQueryParameter("TopicType", topicType);
            this.topicType = topicType;
            return this;
        }

        public Builder where(String where) {
            this.putQueryParameter("Where", where);
            this.where = where;
            return this;
        }

        public CreateRuleRequest build() {
            return new CreateRuleRequest(this);
        }
    }
}

