/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;

public class CreateTopicRouteTableRequest
extends Request {
    @Query
    @NameInMap(value="DstTopic")
    @Validation(required=true)
    private List<String> dstTopic;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="SrcTopic")
    @Validation(required=true)
    private String srcTopic;

    private CreateTopicRouteTableRequest(Builder builder) {
        super((Request.Builder)builder);
        this.dstTopic = builder.dstTopic;
        this.iotInstanceId = builder.iotInstanceId;
        this.srcTopic = builder.srcTopic;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateTopicRouteTableRequest create() {
        return CreateTopicRouteTableRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public List<String> getDstTopic() {
        return this.dstTopic;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getSrcTopic() {
        return this.srcTopic;
    }

    public static final class Builder
    extends Request.Builder<CreateTopicRouteTableRequest, Builder> {
        private List<String> dstTopic;
        private String iotInstanceId;
        private String srcTopic;

        private Builder() {
        }

        private Builder(CreateTopicRouteTableRequest request) {
            super((Request)request);
            this.dstTopic = request.dstTopic;
            this.iotInstanceId = request.iotInstanceId;
            this.srcTopic = request.srcTopic;
        }

        public Builder dstTopic(List<String> dstTopic) {
            this.putQueryParameter("DstTopic", dstTopic);
            this.dstTopic = dstTopic;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder srcTopic(String srcTopic) {
            this.putQueryParameter("SrcTopic", srcTopic);
            this.srcTopic = srcTopic;
            return this;
        }

        public CreateTopicRouteTableRequest build() {
            return new CreateTopicRouteTableRequest(this);
        }
    }
}

