/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class DeleteDataSourceItemRequest
extends Request {
    @Query
    @NameInMap(value="DataSourceId")
    @Validation(required=true, maximum=9.9999999E7)
    private Long dataSourceId;
    @Query
    @NameInMap(value="DataSourceItemId")
    @Validation(required=true, maximum=9.9999999E7)
    private Long dataSourceItemId;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;

    private DeleteDataSourceItemRequest(Builder builder) {
        super((Request.Builder)builder);
        this.dataSourceId = builder.dataSourceId;
        this.dataSourceItemId = builder.dataSourceItemId;
        this.iotInstanceId = builder.iotInstanceId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DeleteDataSourceItemRequest create() {
        return DeleteDataSourceItemRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Long getDataSourceId() {
        return this.dataSourceId;
    }

    public Long getDataSourceItemId() {
        return this.dataSourceItemId;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public static final class Builder
    extends Request.Builder<DeleteDataSourceItemRequest, Builder> {
        private Long dataSourceId;
        private Long dataSourceItemId;
        private String iotInstanceId;

        private Builder() {
        }

        private Builder(DeleteDataSourceItemRequest request) {
            super((Request)request);
            this.dataSourceId = request.dataSourceId;
            this.dataSourceItemId = request.dataSourceItemId;
            this.iotInstanceId = request.iotInstanceId;
        }

        public Builder dataSourceId(Long dataSourceId) {
            this.putQueryParameter("DataSourceId", dataSourceId);
            this.dataSourceId = dataSourceId;
            return this;
        }

        public Builder dataSourceItemId(Long dataSourceItemId) {
            this.putQueryParameter("DataSourceItemId", dataSourceItemId);
            this.dataSourceItemId = dataSourceItemId;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public DeleteDataSourceItemRequest build() {
            return new DeleteDataSourceItemRequest(this);
        }
    }
}

