/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class DeleteParserDataSourceRequest
extends Request {
    @Query
    @NameInMap(value="DataSourceId")
    @Validation(required=true, maximum=9.99999999E8)
    private Long dataSourceId;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;

    private DeleteParserDataSourceRequest(Builder builder) {
        super((Request.Builder)builder);
        this.dataSourceId = builder.dataSourceId;
        this.iotInstanceId = builder.iotInstanceId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DeleteParserDataSourceRequest create() {
        return DeleteParserDataSourceRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Long getDataSourceId() {
        return this.dataSourceId;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public static final class Builder
    extends Request.Builder<DeleteParserDataSourceRequest, Builder> {
        private Long dataSourceId;
        private String iotInstanceId;

        private Builder() {
        }

        private Builder(DeleteParserDataSourceRequest request) {
            super((Request)request);
            this.dataSourceId = request.dataSourceId;
            this.iotInstanceId = request.iotInstanceId;
        }

        public Builder dataSourceId(Long dataSourceId) {
            this.putQueryParameter("DataSourceId", dataSourceId);
            this.dataSourceId = dataSourceId;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public DeleteParserDataSourceRequest build() {
            return new DeleteParserDataSourceRequest(this);
        }
    }
}

