/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;

public class DeleteProductTagsRequest
extends Request {
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="ProductKey")
    @Validation(required=true)
    private String productKey;
    @Query
    @NameInMap(value="ProductTagKey")
    @Validation(required=true)
    private List<String> productTagKey;

    private DeleteProductTagsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.iotInstanceId = builder.iotInstanceId;
        this.productKey = builder.productKey;
        this.productTagKey = builder.productTagKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DeleteProductTagsRequest create() {
        return DeleteProductTagsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public List<String> getProductTagKey() {
        return this.productTagKey;
    }

    public static final class Builder
    extends Request.Builder<DeleteProductTagsRequest, Builder> {
        private String iotInstanceId;
        private String productKey;
        private List<String> productTagKey;

        private Builder() {
        }

        private Builder(DeleteProductTagsRequest request) {
            super((Request)request);
            this.iotInstanceId = request.iotInstanceId;
            this.productKey = request.productKey;
            this.productTagKey = request.productTagKey;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder productKey(String productKey) {
            this.putQueryParameter("ProductKey", productKey);
            this.productKey = productKey;
            return this;
        }

        public Builder productTagKey(List<String> productTagKey) {
            this.putQueryParameter("ProductTagKey", productTagKey);
            this.productTagKey = productTagKey;
            return this;
        }

        public DeleteProductTagsRequest build() {
            return new DeleteProductTagsRequest(this);
        }
    }
}

