/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class DetachDestinationRequest
extends Request {
    @Query
    @NameInMap(value="DestinationId")
    @Validation(required=true, maximum=9.99999999999E11)
    private Long destinationId;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="ParserId")
    @Validation(required=true, maximum=9.999999999E9, minimum=1.0)
    private Long parserId;

    private DetachDestinationRequest(Builder builder) {
        super((Request.Builder)builder);
        this.destinationId = builder.destinationId;
        this.iotInstanceId = builder.iotInstanceId;
        this.parserId = builder.parserId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DetachDestinationRequest create() {
        return DetachDestinationRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Long getDestinationId() {
        return this.destinationId;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public Long getParserId() {
        return this.parserId;
    }

    public static final class Builder
    extends Request.Builder<DetachDestinationRequest, Builder> {
        private Long destinationId;
        private String iotInstanceId;
        private Long parserId;

        private Builder() {
        }

        private Builder(DetachDestinationRequest request) {
            super((Request)request);
            this.destinationId = request.destinationId;
            this.iotInstanceId = request.iotInstanceId;
            this.parserId = request.parserId;
        }

        public Builder destinationId(Long destinationId) {
            this.putQueryParameter("DestinationId", destinationId);
            this.destinationId = destinationId;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder parserId(Long parserId) {
            this.putQueryParameter("ParserId", parserId);
            this.parserId = parserId;
            return this;
        }

        public DetachDestinationRequest build() {
            return new DetachDestinationRequest(this);
        }
    }
}

