/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class GetParserRequest
extends Request {
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="ParserId")
    @Validation(required=true, maximum=9.99999999E8)
    private Long parserId;

    private GetParserRequest(Builder builder) {
        super((Request.Builder)builder);
        this.iotInstanceId = builder.iotInstanceId;
        this.parserId = builder.parserId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static GetParserRequest create() {
        return GetParserRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public Long getParserId() {
        return this.parserId;
    }

    public static final class Builder
    extends Request.Builder<GetParserRequest, Builder> {
        private String iotInstanceId;
        private Long parserId;

        private Builder() {
        }

        private Builder(GetParserRequest request) {
            super((Request)request);
            this.iotInstanceId = request.iotInstanceId;
            this.parserId = request.parserId;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder parserId(Long parserId) {
            this.putQueryParameter("ParserId", parserId);
            this.parserId = parserId;
            return this;
        }

        public GetParserRequest build() {
            return new GetParserRequest(this);
        }
    }
}

