/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class GisQueryDeviceLocationRequest
extends Request {
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="ThingList")
    @Validation(required=true)
    private List<ThingList> thingList;

    private GisQueryDeviceLocationRequest(Builder builder) {
        super((Request.Builder)builder);
        this.iotInstanceId = builder.iotInstanceId;
        this.thingList = builder.thingList;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static GisQueryDeviceLocationRequest create() {
        return GisQueryDeviceLocationRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public List<ThingList> getThingList() {
        return this.thingList;
    }

    public static class ThingList
    extends TeaModel {
        @NameInMap(value="DeviceName")
        private String deviceName;
        @NameInMap(value="ProductKey")
        private String productKey;

        private ThingList(Builder builder) {
            this.deviceName = builder.deviceName;
            this.productKey = builder.productKey;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static ThingList create() {
            return ThingList.builder().build();
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public String getProductKey() {
            return this.productKey;
        }

        public static final class Builder {
            private String deviceName;
            private String productKey;

            public Builder deviceName(String deviceName) {
                this.deviceName = deviceName;
                return this;
            }

            public Builder productKey(String productKey) {
                this.productKey = productKey;
                return this;
            }

            public ThingList build() {
                return new ThingList(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<GisQueryDeviceLocationRequest, Builder> {
        private String iotInstanceId;
        private List<ThingList> thingList;

        private Builder() {
        }

        private Builder(GisQueryDeviceLocationRequest request) {
            super((Request)request);
            this.iotInstanceId = request.iotInstanceId;
            this.thingList = request.thingList;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder thingList(List<ThingList> thingList) {
            this.putQueryParameter("ThingList", thingList);
            this.thingList = thingList;
            return this;
        }

        public GisQueryDeviceLocationRequest build() {
            return new GisQueryDeviceLocationRequest(this);
        }
    }
}

