/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ImportDeviceRequest
extends Request {
    @Query
    @NameInMap(value="DeviceName")
    @Validation(required=true)
    private String deviceName;
    @Query
    @NameInMap(value="DeviceSecret")
    @Validation(required=true)
    private String deviceSecret;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="Nickname")
    private String nickname;
    @Query
    @NameInMap(value="ProductKey")
    @Validation(required=true)
    private String productKey;
    @Query
    @NameInMap(value="Sn")
    private String sn;

    private ImportDeviceRequest(Builder builder) {
        super((Request.Builder)builder);
        this.deviceName = builder.deviceName;
        this.deviceSecret = builder.deviceSecret;
        this.iotInstanceId = builder.iotInstanceId;
        this.nickname = builder.nickname;
        this.productKey = builder.productKey;
        this.sn = builder.sn;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ImportDeviceRequest create() {
        return ImportDeviceRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getDeviceSecret() {
        return this.deviceSecret;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public String getSn() {
        return this.sn;
    }

    public static final class Builder
    extends Request.Builder<ImportDeviceRequest, Builder> {
        private String deviceName;
        private String deviceSecret;
        private String iotInstanceId;
        private String nickname;
        private String productKey;
        private String sn;

        private Builder() {
        }

        private Builder(ImportDeviceRequest request) {
            super((Request)request);
            this.deviceName = request.deviceName;
            this.deviceSecret = request.deviceSecret;
            this.iotInstanceId = request.iotInstanceId;
            this.nickname = request.nickname;
            this.productKey = request.productKey;
            this.sn = request.sn;
        }

        public Builder deviceName(String deviceName) {
            this.putQueryParameter("DeviceName", deviceName);
            this.deviceName = deviceName;
            return this;
        }

        public Builder deviceSecret(String deviceSecret) {
            this.putQueryParameter("DeviceSecret", deviceSecret);
            this.deviceSecret = deviceSecret;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder nickname(String nickname) {
            this.putQueryParameter("Nickname", nickname);
            this.nickname = nickname;
            return this;
        }

        public Builder productKey(String productKey) {
            this.putQueryParameter("ProductKey", productKey);
            this.productKey = productKey;
            return this;
        }

        public Builder sn(String sn) {
            this.putQueryParameter("Sn", sn);
            this.sn = sn;
            return this;
        }

        public ImportDeviceRequest build() {
            return new ImportDeviceRequest(this);
        }
    }
}

