/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListDataSourceItemRequest
extends Request {
    @Query
    @NameInMap(value="DataSourceId")
    @Validation(required=true)
    private Long dataSourceId;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="Page")
    @Validation(required=true, maximum=100000.0, minimum=1.0)
    private Integer page;
    @Query
    @NameInMap(value="PageSize")
    @Validation(required=true, maximum=100.0, minimum=1.0)
    private Integer pageSize;
    @Query
    @NameInMap(value="SearchName")
    private String searchName;

    private ListDataSourceItemRequest(Builder builder) {
        super((Request.Builder)builder);
        this.dataSourceId = builder.dataSourceId;
        this.iotInstanceId = builder.iotInstanceId;
        this.page = builder.page;
        this.pageSize = builder.pageSize;
        this.searchName = builder.searchName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListDataSourceItemRequest create() {
        return ListDataSourceItemRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Long getDataSourceId() {
        return this.dataSourceId;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public Integer getPage() {
        return this.page;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getSearchName() {
        return this.searchName;
    }

    public static final class Builder
    extends Request.Builder<ListDataSourceItemRequest, Builder> {
        private Long dataSourceId;
        private String iotInstanceId;
        private Integer page;
        private Integer pageSize;
        private String searchName;

        private Builder() {
        }

        private Builder(ListDataSourceItemRequest request) {
            super((Request)request);
            this.dataSourceId = request.dataSourceId;
            this.iotInstanceId = request.iotInstanceId;
            this.page = request.page;
            this.pageSize = request.pageSize;
            this.searchName = request.searchName;
        }

        public Builder dataSourceId(Long dataSourceId) {
            this.putQueryParameter("DataSourceId", dataSourceId);
            this.dataSourceId = dataSourceId;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder page(Integer page) {
            this.putQueryParameter("Page", page);
            this.page = page;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder searchName(String searchName) {
            this.putQueryParameter("SearchName", searchName);
            this.searchName = searchName;
            return this;
        }

        public ListDataSourceItemRequest build() {
            return new ListDataSourceItemRequest(this);
        }
    }
}

