/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListDeviceDistributeJobRequest
extends Request {
    @Query
    @NameInMap(value="CurrentPage")
    private Integer currentPage;
    @Body
    @NameInMap(value="JobId")
    private String jobId;
    @Query
    @NameInMap(value="NextToken")
    private String nextToken;
    @Query
    @NameInMap(value="PageSize")
    @Validation(required=true)
    private Integer pageSize;
    @Query
    @NameInMap(value="ProductKey")
    private String productKey;
    @Query
    @NameInMap(value="Status")
    private Integer status;
    @Query
    @NameInMap(value="TargetUid")
    private String targetUid;

    private ListDeviceDistributeJobRequest(Builder builder) {
        super((Request.Builder)builder);
        this.currentPage = builder.currentPage;
        this.jobId = builder.jobId;
        this.nextToken = builder.nextToken;
        this.pageSize = builder.pageSize;
        this.productKey = builder.productKey;
        this.status = builder.status;
        this.targetUid = builder.targetUid;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListDeviceDistributeJobRequest create() {
        return ListDeviceDistributeJobRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Integer getCurrentPage() {
        return this.currentPage;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getTargetUid() {
        return this.targetUid;
    }

    public static final class Builder
    extends Request.Builder<ListDeviceDistributeJobRequest, Builder> {
        private Integer currentPage;
        private String jobId;
        private String nextToken;
        private Integer pageSize;
        private String productKey;
        private Integer status;
        private String targetUid;

        private Builder() {
        }

        private Builder(ListDeviceDistributeJobRequest request) {
            super((Request)request);
            this.currentPage = request.currentPage;
            this.jobId = request.jobId;
            this.nextToken = request.nextToken;
            this.pageSize = request.pageSize;
            this.productKey = request.productKey;
            this.status = request.status;
            this.targetUid = request.targetUid;
        }

        public Builder currentPage(Integer currentPage) {
            this.putQueryParameter("CurrentPage", currentPage);
            this.currentPage = currentPage;
            return this;
        }

        public Builder jobId(String jobId) {
            this.putBodyParameter("JobId", jobId);
            this.jobId = jobId;
            return this;
        }

        public Builder nextToken(String nextToken) {
            this.putQueryParameter("NextToken", nextToken);
            this.nextToken = nextToken;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder productKey(String productKey) {
            this.putQueryParameter("ProductKey", productKey);
            this.productKey = productKey;
            return this;
        }

        public Builder status(Integer status) {
            this.putQueryParameter("Status", status);
            this.status = status;
            return this;
        }

        public Builder targetUid(String targetUid) {
            this.putQueryParameter("TargetUid", targetUid);
            this.targetUid = targetUid;
            return this;
        }

        public ListDeviceDistributeJobRequest build() {
            return new ListDeviceDistributeJobRequest(this);
        }
    }
}

