/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;

public class ListOTATaskByJobRequest
extends Request {
    @Query
    @NameInMap(value="CurrentPage")
    private Integer currentPage;
    @Query
    @NameInMap(value="DeviceNames")
    private List<String> deviceNames;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="JobId")
    @Validation(required=true)
    private String jobId;
    @Query
    @NameInMap(value="PageSize")
    private Integer pageSize;
    @Query
    @NameInMap(value="TaskStatus")
    private String taskStatus;

    private ListOTATaskByJobRequest(Builder builder) {
        super((Request.Builder)builder);
        this.currentPage = builder.currentPage;
        this.deviceNames = builder.deviceNames;
        this.iotInstanceId = builder.iotInstanceId;
        this.jobId = builder.jobId;
        this.pageSize = builder.pageSize;
        this.taskStatus = builder.taskStatus;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListOTATaskByJobRequest create() {
        return ListOTATaskByJobRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Integer getCurrentPage() {
        return this.currentPage;
    }

    public List<String> getDeviceNames() {
        return this.deviceNames;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getTaskStatus() {
        return this.taskStatus;
    }

    public static final class Builder
    extends Request.Builder<ListOTATaskByJobRequest, Builder> {
        private Integer currentPage;
        private List<String> deviceNames;
        private String iotInstanceId;
        private String jobId;
        private Integer pageSize;
        private String taskStatus;

        private Builder() {
        }

        private Builder(ListOTATaskByJobRequest request) {
            super((Request)request);
            this.currentPage = request.currentPage;
            this.deviceNames = request.deviceNames;
            this.iotInstanceId = request.iotInstanceId;
            this.jobId = request.jobId;
            this.pageSize = request.pageSize;
            this.taskStatus = request.taskStatus;
        }

        public Builder currentPage(Integer currentPage) {
            this.putQueryParameter("CurrentPage", currentPage);
            this.currentPage = currentPage;
            return this;
        }

        public Builder deviceNames(List<String> deviceNames) {
            this.putQueryParameter("DeviceNames", deviceNames);
            this.deviceNames = deviceNames;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder jobId(String jobId) {
            this.putQueryParameter("JobId", jobId);
            this.jobId = jobId;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder taskStatus(String taskStatus) {
            this.putQueryParameter("TaskStatus", taskStatus);
            this.taskStatus = taskStatus;
            return this;
        }

        public ListOTATaskByJobRequest build() {
            return new ListOTATaskByJobRequest(this);
        }
    }
}

