/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListParserRequest
extends Request {
    @Query
    @NameInMap(value="CurrentPage")
    @Validation(required=true, maximum=100.0, minimum=1.0)
    private Integer currentPage;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="PageSize")
    @Validation(required=true, maximum=100.0)
    private Integer pageSize;
    @Query
    @NameInMap(value="SearchName")
    private String searchName;

    private ListParserRequest(Builder builder) {
        super((Request.Builder)builder);
        this.currentPage = builder.currentPage;
        this.iotInstanceId = builder.iotInstanceId;
        this.pageSize = builder.pageSize;
        this.searchName = builder.searchName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListParserRequest create() {
        return ListParserRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Integer getCurrentPage() {
        return this.currentPage;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getSearchName() {
        return this.searchName;
    }

    public static final class Builder
    extends Request.Builder<ListParserRequest, Builder> {
        private Integer currentPage;
        private String iotInstanceId;
        private Integer pageSize;
        private String searchName;

        private Builder() {
        }

        private Builder(ListParserRequest request) {
            super((Request)request);
            this.currentPage = request.currentPage;
            this.iotInstanceId = request.iotInstanceId;
            this.pageSize = request.pageSize;
            this.searchName = request.searchName;
        }

        public Builder currentPage(Integer currentPage) {
            this.putQueryParameter("CurrentPage", currentPage);
            this.currentPage = currentPage;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder searchName(String searchName) {
            this.putQueryParameter("SearchName", searchName);
            this.searchName = searchName;
            return this;
        }

        public ListParserRequest build() {
            return new ListParserRequest(this);
        }
    }
}

