/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class ListProductByTagsRequest
extends Request {
    @Query
    @NameInMap(value="CurrentPage")
    private Integer currentPage;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="PageSize")
    private Integer pageSize;
    @Query
    @NameInMap(value="ProductTag")
    @Validation(required=true)
    private List<ProductTag> productTag;

    private ListProductByTagsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.currentPage = builder.currentPage;
        this.iotInstanceId = builder.iotInstanceId;
        this.pageSize = builder.pageSize;
        this.productTag = builder.productTag;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListProductByTagsRequest create() {
        return ListProductByTagsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Integer getCurrentPage() {
        return this.currentPage;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public List<ProductTag> getProductTag() {
        return this.productTag;
    }

    public static class ProductTag
    extends TeaModel {
        @NameInMap(value="TagKey")
        @Validation(required=true)
        private String tagKey;
        @NameInMap(value="TagValue")
        private String tagValue;

        private ProductTag(Builder builder) {
            this.tagKey = builder.tagKey;
            this.tagValue = builder.tagValue;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static ProductTag create() {
            return ProductTag.builder().build();
        }

        public String getTagKey() {
            return this.tagKey;
        }

        public String getTagValue() {
            return this.tagValue;
        }

        public static final class Builder {
            private String tagKey;
            private String tagValue;

            public Builder tagKey(String tagKey) {
                this.tagKey = tagKey;
                return this;
            }

            public Builder tagValue(String tagValue) {
                this.tagValue = tagValue;
                return this;
            }

            public ProductTag build() {
                return new ProductTag(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<ListProductByTagsRequest, Builder> {
        private Integer currentPage;
        private String iotInstanceId;
        private Integer pageSize;
        private List<ProductTag> productTag;

        private Builder() {
        }

        private Builder(ListProductByTagsRequest request) {
            super((Request)request);
            this.currentPage = request.currentPage;
            this.iotInstanceId = request.iotInstanceId;
            this.pageSize = request.pageSize;
            this.productTag = request.productTag;
        }

        public Builder currentPage(Integer currentPage) {
            this.putQueryParameter("CurrentPage", currentPage);
            this.currentPage = currentPage;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder productTag(List<ProductTag> productTag) {
            this.putQueryParameter("ProductTag", productTag);
            this.productTag = productTag;
            return this;
        }

        public ListProductByTagsRequest build() {
            return new ListProductByTagsRequest(this);
        }
    }
}

