/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.Map;

public class ListTaskRequest
extends Request {
    @Query
    @NameInMap(value="Device")
    private Map<String, ?> device;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="JobId")
    private String jobId;
    @Query
    @NameInMap(value="Limit")
    @Validation(required=true, maximum=50.0, minimum=1.0)
    private Integer limit;
    @Query
    @NameInMap(value="NextToken")
    private String nextToken;
    @Query
    @NameInMap(value="Status")
    private String status;

    private ListTaskRequest(Builder builder) {
        super((Request.Builder)builder);
        this.device = builder.device;
        this.iotInstanceId = builder.iotInstanceId;
        this.jobId = builder.jobId;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
        this.status = builder.status;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListTaskRequest create() {
        return ListTaskRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Map<String, ?> getDevice() {
        return this.device;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public String getStatus() {
        return this.status;
    }

    public static final class Builder
    extends Request.Builder<ListTaskRequest, Builder> {
        private Map<String, ?> device;
        private String iotInstanceId;
        private String jobId;
        private Integer limit;
        private String nextToken;
        private String status;

        private Builder() {
        }

        private Builder(ListTaskRequest request) {
            super((Request)request);
            this.device = request.device;
            this.iotInstanceId = request.iotInstanceId;
            this.jobId = request.jobId;
            this.limit = request.limit;
            this.nextToken = request.nextToken;
            this.status = request.status;
        }

        public Builder device(Map<String, ?> device) {
            String deviceShrink = this.shrink(device, "Device", "json");
            this.putQueryParameter("Device", deviceShrink);
            this.device = device;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder jobId(String jobId) {
            this.putQueryParameter("JobId", jobId);
            this.jobId = jobId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.putQueryParameter("Limit", limit);
            this.limit = limit;
            return this;
        }

        public Builder nextToken(String nextToken) {
            this.putQueryParameter("NextToken", nextToken);
            this.nextToken = nextToken;
            return this;
        }

        public Builder status(String status) {
            this.putQueryParameter("Status", status);
            this.status = status;
            return this;
        }

        public ListTaskRequest build() {
            return new ListTaskRequest(this);
        }
    }
}

