/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;

public class PushSpeechRequest
extends Request {
    @Body
    @NameInMap(value="DeviceName")
    private String deviceName;
    @Query
    @NameInMap(value="GroupId")
    private String groupId;
    @Body
    @NameInMap(value="IotId")
    private String iotId;
    @Body
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Body
    @NameInMap(value="ProductKey")
    private String productKey;
    @Body
    @NameInMap(value="ProjectCode")
    @Validation(required=true)
    private String projectCode;
    @Body
    @NameInMap(value="PushMode")
    @Validation(required=true)
    private String pushMode;
    @Body
    @NameInMap(value="SpeechCodeList")
    @Validation(required=true)
    private List<String> speechCodeList;

    private PushSpeechRequest(Builder builder) {
        super((Request.Builder)builder);
        this.deviceName = builder.deviceName;
        this.groupId = builder.groupId;
        this.iotId = builder.iotId;
        this.iotInstanceId = builder.iotInstanceId;
        this.productKey = builder.productKey;
        this.projectCode = builder.projectCode;
        this.pushMode = builder.pushMode;
        this.speechCodeList = builder.speechCodeList;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static PushSpeechRequest create() {
        return PushSpeechRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getIotId() {
        return this.iotId;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public String getProjectCode() {
        return this.projectCode;
    }

    public String getPushMode() {
        return this.pushMode;
    }

    public List<String> getSpeechCodeList() {
        return this.speechCodeList;
    }

    public static final class Builder
    extends Request.Builder<PushSpeechRequest, Builder> {
        private String deviceName;
        private String groupId;
        private String iotId;
        private String iotInstanceId;
        private String productKey;
        private String projectCode;
        private String pushMode;
        private List<String> speechCodeList;

        private Builder() {
        }

        private Builder(PushSpeechRequest request) {
            super((Request)request);
            this.deviceName = request.deviceName;
            this.groupId = request.groupId;
            this.iotId = request.iotId;
            this.iotInstanceId = request.iotInstanceId;
            this.productKey = request.productKey;
            this.projectCode = request.projectCode;
            this.pushMode = request.pushMode;
            this.speechCodeList = request.speechCodeList;
        }

        public Builder deviceName(String deviceName) {
            this.putBodyParameter("DeviceName", deviceName);
            this.deviceName = deviceName;
            return this;
        }

        public Builder groupId(String groupId) {
            this.putQueryParameter("GroupId", groupId);
            this.groupId = groupId;
            return this;
        }

        public Builder iotId(String iotId) {
            this.putBodyParameter("IotId", iotId);
            this.iotId = iotId;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putBodyParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder productKey(String productKey) {
            this.putBodyParameter("ProductKey", productKey);
            this.productKey = productKey;
            return this;
        }

        public Builder projectCode(String projectCode) {
            this.putBodyParameter("ProjectCode", projectCode);
            this.projectCode = projectCode;
            return this;
        }

        public Builder pushMode(String pushMode) {
            this.putBodyParameter("PushMode", pushMode);
            this.pushMode = pushMode;
            return this;
        }

        public Builder speechCodeList(List<String> speechCodeList) {
            this.putBodyParameter("SpeechCodeList", speechCodeList);
            this.speechCodeList = speechCodeList;
            return this;
        }

        public PushSpeechRequest build() {
            return new PushSpeechRequest(this);
        }
    }
}

