/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class QueryConsumerGroupListRequest
extends Request {
    @Query
    @NameInMap(value="CurrentPage")
    @Validation(required=true)
    private Integer currentPage;
    @Query
    @NameInMap(value="Fuzzy")
    private Boolean fuzzy;
    @Query
    @NameInMap(value="GroupName")
    private String groupName;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="PageSize")
    @Validation(required=true)
    private Integer pageSize;

    private QueryConsumerGroupListRequest(Builder builder) {
        super((Request.Builder)builder);
        this.currentPage = builder.currentPage;
        this.fuzzy = builder.fuzzy;
        this.groupName = builder.groupName;
        this.iotInstanceId = builder.iotInstanceId;
        this.pageSize = builder.pageSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static QueryConsumerGroupListRequest create() {
        return QueryConsumerGroupListRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Integer getCurrentPage() {
        return this.currentPage;
    }

    public Boolean getFuzzy() {
        return this.fuzzy;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public static final class Builder
    extends Request.Builder<QueryConsumerGroupListRequest, Builder> {
        private Integer currentPage;
        private Boolean fuzzy;
        private String groupName;
        private String iotInstanceId;
        private Integer pageSize;

        private Builder() {
        }

        private Builder(QueryConsumerGroupListRequest request) {
            super((Request)request);
            this.currentPage = request.currentPage;
            this.fuzzy = request.fuzzy;
            this.groupName = request.groupName;
            this.iotInstanceId = request.iotInstanceId;
            this.pageSize = request.pageSize;
        }

        public Builder currentPage(Integer currentPage) {
            this.putQueryParameter("CurrentPage", currentPage);
            this.currentPage = currentPage;
            return this;
        }

        public Builder fuzzy(Boolean fuzzy) {
            this.putQueryParameter("Fuzzy", fuzzy);
            this.fuzzy = fuzzy;
            return this;
        }

        public Builder groupName(String groupName) {
            this.putQueryParameter("GroupName", groupName);
            this.groupName = groupName;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public QueryConsumerGroupListRequest build() {
            return new QueryConsumerGroupListRequest(this);
        }
    }
}

