/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class QueryDeviceByStatusRequest
extends Request {
    @Query
    @NameInMap(value="CurrentPage")
    private Integer currentPage;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="PageSize")
    private Integer pageSize;
    @Query
    @NameInMap(value="ProductKey")
    private String productKey;
    @Query
    @NameInMap(value="ResourceGroupId")
    private String resourceGroupId;
    @Query
    @NameInMap(value="Status")
    @Validation(required=true)
    private Integer status;

    private QueryDeviceByStatusRequest(Builder builder) {
        super((Request.Builder)builder);
        this.currentPage = builder.currentPage;
        this.iotInstanceId = builder.iotInstanceId;
        this.pageSize = builder.pageSize;
        this.productKey = builder.productKey;
        this.resourceGroupId = builder.resourceGroupId;
        this.status = builder.status;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static QueryDeviceByStatusRequest create() {
        return QueryDeviceByStatusRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Integer getCurrentPage() {
        return this.currentPage;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public String getResourceGroupId() {
        return this.resourceGroupId;
    }

    public Integer getStatus() {
        return this.status;
    }

    public static final class Builder
    extends Request.Builder<QueryDeviceByStatusRequest, Builder> {
        private Integer currentPage;
        private String iotInstanceId;
        private Integer pageSize;
        private String productKey;
        private String resourceGroupId;
        private Integer status;

        private Builder() {
        }

        private Builder(QueryDeviceByStatusRequest request) {
            super((Request)request);
            this.currentPage = request.currentPage;
            this.iotInstanceId = request.iotInstanceId;
            this.pageSize = request.pageSize;
            this.productKey = request.productKey;
            this.resourceGroupId = request.resourceGroupId;
            this.status = request.status;
        }

        public Builder currentPage(Integer currentPage) {
            this.putQueryParameter("CurrentPage", currentPage);
            this.currentPage = currentPage;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder productKey(String productKey) {
            this.putQueryParameter("ProductKey", productKey);
            this.productKey = productKey;
            return this;
        }

        public Builder resourceGroupId(String resourceGroupId) {
            this.putQueryParameter("ResourceGroupId", resourceGroupId);
            this.resourceGroupId = resourceGroupId;
            return this;
        }

        public Builder status(Integer status) {
            this.putQueryParameter("Status", status);
            this.status = status;
            return this;
        }

        public QueryDeviceByStatusRequest build() {
            return new QueryDeviceByStatusRequest(this);
        }
    }
}

