/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;

public class QueryDeviceGroupListRequest
extends Request {
    @Query
    @NameInMap(value="CurrentPage")
    private Integer currentPage;
    @Query
    @NameInMap(value="GroupName")
    private String groupName;
    @Query
    @NameInMap(value="GroupTypes")
    private List<String> groupTypes;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="PageSize")
    private Integer pageSize;
    @Query
    @NameInMap(value="SuperGroupId")
    private String superGroupId;

    private QueryDeviceGroupListRequest(Builder builder) {
        super((Request.Builder)builder);
        this.currentPage = builder.currentPage;
        this.groupName = builder.groupName;
        this.groupTypes = builder.groupTypes;
        this.iotInstanceId = builder.iotInstanceId;
        this.pageSize = builder.pageSize;
        this.superGroupId = builder.superGroupId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static QueryDeviceGroupListRequest create() {
        return QueryDeviceGroupListRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Integer getCurrentPage() {
        return this.currentPage;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public List<String> getGroupTypes() {
        return this.groupTypes;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getSuperGroupId() {
        return this.superGroupId;
    }

    public static final class Builder
    extends Request.Builder<QueryDeviceGroupListRequest, Builder> {
        private Integer currentPage;
        private String groupName;
        private List<String> groupTypes;
        private String iotInstanceId;
        private Integer pageSize;
        private String superGroupId;

        private Builder() {
        }

        private Builder(QueryDeviceGroupListRequest request) {
            super((Request)request);
            this.currentPage = request.currentPage;
            this.groupName = request.groupName;
            this.groupTypes = request.groupTypes;
            this.iotInstanceId = request.iotInstanceId;
            this.pageSize = request.pageSize;
            this.superGroupId = request.superGroupId;
        }

        public Builder currentPage(Integer currentPage) {
            this.putQueryParameter("CurrentPage", currentPage);
            this.currentPage = currentPage;
            return this;
        }

        public Builder groupName(String groupName) {
            this.putQueryParameter("GroupName", groupName);
            this.groupName = groupName;
            return this;
        }

        public Builder groupTypes(List<String> groupTypes) {
            this.putQueryParameter("GroupTypes", groupTypes);
            this.groupTypes = groupTypes;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder superGroupId(String superGroupId) {
            this.putQueryParameter("SuperGroupId", superGroupId);
            this.superGroupId = superGroupId;
            return this;
        }

        public QueryDeviceGroupListRequest build() {
            return new QueryDeviceGroupListRequest(this);
        }
    }
}

