/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class QueryDeviceSpeechRequest
extends Request {
    @Body
    @NameInMap(value="IotId")
    @Validation(required=true)
    private String iotId;
    @Body
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Body
    @NameInMap(value="PageId")
    @Validation(maximum=10000.0, minimum=1.0)
    private Integer pageId;
    @Body
    @NameInMap(value="PageSize")
    @Validation(maximum=50.0, minimum=1.0)
    private Integer pageSize;

    private QueryDeviceSpeechRequest(Builder builder) {
        super((Request.Builder)builder);
        this.iotId = builder.iotId;
        this.iotInstanceId = builder.iotInstanceId;
        this.pageId = builder.pageId;
        this.pageSize = builder.pageSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static QueryDeviceSpeechRequest create() {
        return QueryDeviceSpeechRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getIotId() {
        return this.iotId;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public Integer getPageId() {
        return this.pageId;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public static final class Builder
    extends Request.Builder<QueryDeviceSpeechRequest, Builder> {
        private String iotId;
        private String iotInstanceId;
        private Integer pageId;
        private Integer pageSize;

        private Builder() {
        }

        private Builder(QueryDeviceSpeechRequest request) {
            super((Request)request);
            this.iotId = request.iotId;
            this.iotInstanceId = request.iotInstanceId;
            this.pageId = request.pageId;
            this.pageSize = request.pageSize;
        }

        public Builder iotId(String iotId) {
            this.putBodyParameter("IotId", iotId);
            this.iotId = iotId;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putBodyParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder pageId(Integer pageId) {
            this.putBodyParameter("PageId", pageId);
            this.pageId = pageId;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putBodyParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public QueryDeviceSpeechRequest build() {
            return new QueryDeviceSpeechRequest(this);
        }
    }
}

