/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class QueryDynamicGroupDevicesRequest
extends Request {
    @Query
    @NameInMap(value="CurrentPage")
    private Integer currentPage;
    @Query
    @NameInMap(value="DeviceName")
    private String deviceName;
    @Query
    @NameInMap(value="FuzzyName")
    private Boolean fuzzyName;
    @Query
    @NameInMap(value="GroupId")
    @Validation(required=true)
    private String groupId;
    @Query
    @NameInMap(value="IotInstanceId")
    @Validation(required=true)
    private String iotInstanceId;
    @Query
    @NameInMap(value="NextToken")
    private String nextToken;
    @Query
    @NameInMap(value="PageSize")
    private Integer pageSize;
    @Query
    @NameInMap(value="ProductKey")
    private String productKey;
    @Query
    @NameInMap(value="Status")
    private String status;

    private QueryDynamicGroupDevicesRequest(Builder builder) {
        super((Request.Builder)builder);
        this.currentPage = builder.currentPage;
        this.deviceName = builder.deviceName;
        this.fuzzyName = builder.fuzzyName;
        this.groupId = builder.groupId;
        this.iotInstanceId = builder.iotInstanceId;
        this.nextToken = builder.nextToken;
        this.pageSize = builder.pageSize;
        this.productKey = builder.productKey;
        this.status = builder.status;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static QueryDynamicGroupDevicesRequest create() {
        return QueryDynamicGroupDevicesRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Integer getCurrentPage() {
        return this.currentPage;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public Boolean getFuzzyName() {
        return this.fuzzyName;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public String getStatus() {
        return this.status;
    }

    public static final class Builder
    extends Request.Builder<QueryDynamicGroupDevicesRequest, Builder> {
        private Integer currentPage;
        private String deviceName;
        private Boolean fuzzyName;
        private String groupId;
        private String iotInstanceId;
        private String nextToken;
        private Integer pageSize;
        private String productKey;
        private String status;

        private Builder() {
        }

        private Builder(QueryDynamicGroupDevicesRequest request) {
            super((Request)request);
            this.currentPage = request.currentPage;
            this.deviceName = request.deviceName;
            this.fuzzyName = request.fuzzyName;
            this.groupId = request.groupId;
            this.iotInstanceId = request.iotInstanceId;
            this.nextToken = request.nextToken;
            this.pageSize = request.pageSize;
            this.productKey = request.productKey;
            this.status = request.status;
        }

        public Builder currentPage(Integer currentPage) {
            this.putQueryParameter("CurrentPage", currentPage);
            this.currentPage = currentPage;
            return this;
        }

        public Builder deviceName(String deviceName) {
            this.putQueryParameter("DeviceName", deviceName);
            this.deviceName = deviceName;
            return this;
        }

        public Builder fuzzyName(Boolean fuzzyName) {
            this.putQueryParameter("FuzzyName", fuzzyName);
            this.fuzzyName = fuzzyName;
            return this;
        }

        public Builder groupId(String groupId) {
            this.putQueryParameter("GroupId", groupId);
            this.groupId = groupId;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder nextToken(String nextToken) {
            this.putQueryParameter("NextToken", nextToken);
            this.nextToken = nextToken;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder productKey(String productKey) {
            this.putQueryParameter("ProductKey", productKey);
            this.productKey = productKey;
            return this;
        }

        public Builder status(String status) {
            this.putQueryParameter("Status", status);
            this.status = status;
            return this;
        }

        public QueryDynamicGroupDevicesRequest build() {
            return new QueryDynamicGroupDevicesRequest(this);
        }
    }
}

