/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class QueryImportedDeviceByApplyIdRequest
extends Request {
    @Query
    @NameInMap(value="ApplyId")
    @Validation(required=true, minimum=1.0)
    private Long applyId;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="PageNo")
    @Validation(required=true, maximum=100000.0, minimum=1.0)
    private Integer pageNo;
    @Query
    @NameInMap(value="PageSize")
    @Validation(required=true, maximum=1000.0, minimum=1.0)
    private Integer pageSize;

    private QueryImportedDeviceByApplyIdRequest(Builder builder) {
        super((Request.Builder)builder);
        this.applyId = builder.applyId;
        this.iotInstanceId = builder.iotInstanceId;
        this.pageNo = builder.pageNo;
        this.pageSize = builder.pageSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static QueryImportedDeviceByApplyIdRequest create() {
        return QueryImportedDeviceByApplyIdRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Long getApplyId() {
        return this.applyId;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public Integer getPageNo() {
        return this.pageNo;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public static final class Builder
    extends Request.Builder<QueryImportedDeviceByApplyIdRequest, Builder> {
        private Long applyId;
        private String iotInstanceId;
        private Integer pageNo;
        private Integer pageSize;

        private Builder() {
        }

        private Builder(QueryImportedDeviceByApplyIdRequest request) {
            super((Request)request);
            this.applyId = request.applyId;
            this.iotInstanceId = request.iotInstanceId;
            this.pageNo = request.pageNo;
            this.pageSize = request.pageSize;
        }

        public Builder applyId(Long applyId) {
            this.putQueryParameter("ApplyId", applyId);
            this.applyId = applyId;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder pageNo(Integer pageNo) {
            this.putQueryParameter("PageNo", pageNo);
            this.pageNo = pageNo;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public QueryImportedDeviceByApplyIdRequest build() {
            return new QueryImportedDeviceByApplyIdRequest(this);
        }
    }
}

