/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class QuerySoundCodeLabelListRequest
extends Request {
    @Body
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Body
    @NameInMap(value="PageId")
    @Validation(maximum=10000.0, minimum=1.0)
    private Integer pageId;
    @Body
    @NameInMap(value="PageSize")
    @Validation(maximum=50.0, minimum=1.0)
    private Integer pageSize;
    @Body
    @NameInMap(value="ScheduleCode")
    @Validation(required=true)
    private String scheduleCode;

    private QuerySoundCodeLabelListRequest(Builder builder) {
        super((Request.Builder)builder);
        this.iotInstanceId = builder.iotInstanceId;
        this.pageId = builder.pageId;
        this.pageSize = builder.pageSize;
        this.scheduleCode = builder.scheduleCode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static QuerySoundCodeLabelListRequest create() {
        return QuerySoundCodeLabelListRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public Integer getPageId() {
        return this.pageId;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getScheduleCode() {
        return this.scheduleCode;
    }

    public static final class Builder
    extends Request.Builder<QuerySoundCodeLabelListRequest, Builder> {
        private String iotInstanceId;
        private Integer pageId;
        private Integer pageSize;
        private String scheduleCode;

        private Builder() {
        }

        private Builder(QuerySoundCodeLabelListRequest request) {
            super((Request)request);
            this.iotInstanceId = request.iotInstanceId;
            this.pageId = request.pageId;
            this.pageSize = request.pageSize;
            this.scheduleCode = request.scheduleCode;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putBodyParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder pageId(Integer pageId) {
            this.putBodyParameter("PageId", pageId);
            this.pageId = pageId;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putBodyParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder scheduleCode(String scheduleCode) {
            this.putBodyParameter("ScheduleCode", scheduleCode);
            this.scheduleCode = scheduleCode;
            return this;
        }

        public QuerySoundCodeLabelListRequest build() {
            return new QuerySoundCodeLabelListRequest(this);
        }
    }
}

