/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;

public class QuerySpeechPushJobRequest
extends Request {
    @Body
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="JobCode")
    private String jobCode;
    @Body
    @NameInMap(value="PageId")
    @Validation(maximum=10000.0, minimum=1.0)
    private Integer pageId;
    @Body
    @NameInMap(value="PageSize")
    @Validation(maximum=50.0, minimum=1.0)
    private Integer pageSize;
    @Body
    @NameInMap(value="ProjectCode")
    @Validation(required=true)
    private String projectCode;
    @Body
    @NameInMap(value="PushMode")
    private String pushMode;
    @Body
    @NameInMap(value="StatusList")
    private List<String> statusList;

    private QuerySpeechPushJobRequest(Builder builder) {
        super((Request.Builder)builder);
        this.iotInstanceId = builder.iotInstanceId;
        this.jobCode = builder.jobCode;
        this.pageId = builder.pageId;
        this.pageSize = builder.pageSize;
        this.projectCode = builder.projectCode;
        this.pushMode = builder.pushMode;
        this.statusList = builder.statusList;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static QuerySpeechPushJobRequest create() {
        return QuerySpeechPushJobRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getJobCode() {
        return this.jobCode;
    }

    public Integer getPageId() {
        return this.pageId;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getProjectCode() {
        return this.projectCode;
    }

    public String getPushMode() {
        return this.pushMode;
    }

    public List<String> getStatusList() {
        return this.statusList;
    }

    public static final class Builder
    extends Request.Builder<QuerySpeechPushJobRequest, Builder> {
        private String iotInstanceId;
        private String jobCode;
        private Integer pageId;
        private Integer pageSize;
        private String projectCode;
        private String pushMode;
        private List<String> statusList;

        private Builder() {
        }

        private Builder(QuerySpeechPushJobRequest request) {
            super((Request)request);
            this.iotInstanceId = request.iotInstanceId;
            this.jobCode = request.jobCode;
            this.pageId = request.pageId;
            this.pageSize = request.pageSize;
            this.projectCode = request.projectCode;
            this.pushMode = request.pushMode;
            this.statusList = request.statusList;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putBodyParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder jobCode(String jobCode) {
            this.putQueryParameter("JobCode", jobCode);
            this.jobCode = jobCode;
            return this;
        }

        public Builder pageId(Integer pageId) {
            this.putBodyParameter("PageId", pageId);
            this.pageId = pageId;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putBodyParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder projectCode(String projectCode) {
            this.putBodyParameter("ProjectCode", projectCode);
            this.projectCode = projectCode;
            return this;
        }

        public Builder pushMode(String pushMode) {
            this.putBodyParameter("PushMode", pushMode);
            this.pushMode = pushMode;
            return this;
        }

        public Builder statusList(List<String> statusList) {
            this.putBodyParameter("StatusList", statusList);
            this.statusList = statusList;
            return this;
        }

        public QuerySpeechPushJobRequest build() {
            return new QuerySpeechPushJobRequest(this);
        }
    }
}

