/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class RRpcRequest
extends Request {
    @Query
    @NameInMap(value="ContentType")
    private String contentType;
    @Query
    @NameInMap(value="DeviceName")
    @Validation(required=true)
    private String deviceName;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="ProductKey")
    @Validation(required=true)
    private String productKey;
    @Query
    @NameInMap(value="RequestBase64Byte")
    @Validation(required=true)
    private String requestBase64Byte;
    @Query
    @NameInMap(value="Timeout")
    @Validation(required=true)
    private Integer timeout;
    @Query
    @NameInMap(value="Topic")
    private String topic;

    private RRpcRequest(Builder builder) {
        super((Request.Builder)builder);
        this.contentType = builder.contentType;
        this.deviceName = builder.deviceName;
        this.iotInstanceId = builder.iotInstanceId;
        this.productKey = builder.productKey;
        this.requestBase64Byte = builder.requestBase64Byte;
        this.timeout = builder.timeout;
        this.topic = builder.topic;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static RRpcRequest create() {
        return RRpcRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public String getRequestBase64Byte() {
        return this.requestBase64Byte;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public String getTopic() {
        return this.topic;
    }

    public static final class Builder
    extends Request.Builder<RRpcRequest, Builder> {
        private String contentType;
        private String deviceName;
        private String iotInstanceId;
        private String productKey;
        private String requestBase64Byte;
        private Integer timeout;
        private String topic;

        private Builder() {
        }

        private Builder(RRpcRequest request) {
            super((Request)request);
            this.contentType = request.contentType;
            this.deviceName = request.deviceName;
            this.iotInstanceId = request.iotInstanceId;
            this.productKey = request.productKey;
            this.requestBase64Byte = request.requestBase64Byte;
            this.timeout = request.timeout;
            this.topic = request.topic;
        }

        public Builder contentType(String contentType) {
            this.putQueryParameter("ContentType", contentType);
            this.contentType = contentType;
            return this;
        }

        public Builder deviceName(String deviceName) {
            this.putQueryParameter("DeviceName", deviceName);
            this.deviceName = deviceName;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder productKey(String productKey) {
            this.putQueryParameter("ProductKey", productKey);
            this.productKey = productKey;
            return this;
        }

        public Builder requestBase64Byte(String requestBase64Byte) {
            this.putQueryParameter("RequestBase64Byte", requestBase64Byte);
            this.requestBase64Byte = requestBase64Byte;
            return this;
        }

        public Builder timeout(Integer timeout) {
            this.putQueryParameter("Timeout", timeout);
            this.timeout = timeout;
            return this;
        }

        public Builder topic(String topic) {
            this.putQueryParameter("Topic", topic);
            this.topic = topic;
            return this;
        }

        public RRpcRequest build() {
            return new RRpcRequest(this);
        }
    }
}

