/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class RegisterDeviceRequest
extends Request {
    @Query
    @NameInMap(value="AppKey")
    private String appKey;
    @Query
    @NameInMap(value="DevEui")
    private String devEui;
    @Query
    @NameInMap(value="DeviceName")
    private String deviceName;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="JoinEui")
    private String joinEui;
    @Query
    @NameInMap(value="LoraNodeType")
    private String loraNodeType;
    @Query
    @NameInMap(value="Nickname")
    private String nickname;
    @Query
    @NameInMap(value="PinCode")
    private String pinCode;
    @Query
    @NameInMap(value="ProductKey")
    @Validation(required=true)
    private String productKey;

    private RegisterDeviceRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appKey = builder.appKey;
        this.devEui = builder.devEui;
        this.deviceName = builder.deviceName;
        this.iotInstanceId = builder.iotInstanceId;
        this.joinEui = builder.joinEui;
        this.loraNodeType = builder.loraNodeType;
        this.nickname = builder.nickname;
        this.pinCode = builder.pinCode;
        this.productKey = builder.productKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static RegisterDeviceRequest create() {
        return RegisterDeviceRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getDevEui() {
        return this.devEui;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getJoinEui() {
        return this.joinEui;
    }

    public String getLoraNodeType() {
        return this.loraNodeType;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getPinCode() {
        return this.pinCode;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public static final class Builder
    extends Request.Builder<RegisterDeviceRequest, Builder> {
        private String appKey;
        private String devEui;
        private String deviceName;
        private String iotInstanceId;
        private String joinEui;
        private String loraNodeType;
        private String nickname;
        private String pinCode;
        private String productKey;

        private Builder() {
        }

        private Builder(RegisterDeviceRequest request) {
            super((Request)request);
            this.appKey = request.appKey;
            this.devEui = request.devEui;
            this.deviceName = request.deviceName;
            this.iotInstanceId = request.iotInstanceId;
            this.joinEui = request.joinEui;
            this.loraNodeType = request.loraNodeType;
            this.nickname = request.nickname;
            this.pinCode = request.pinCode;
            this.productKey = request.productKey;
        }

        public Builder appKey(String appKey) {
            this.putQueryParameter("AppKey", appKey);
            this.appKey = appKey;
            return this;
        }

        public Builder devEui(String devEui) {
            this.putQueryParameter("DevEui", devEui);
            this.devEui = devEui;
            return this;
        }

        public Builder deviceName(String deviceName) {
            this.putQueryParameter("DeviceName", deviceName);
            this.deviceName = deviceName;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder joinEui(String joinEui) {
            this.putQueryParameter("JoinEui", joinEui);
            this.joinEui = joinEui;
            return this;
        }

        public Builder loraNodeType(String loraNodeType) {
            this.putQueryParameter("LoraNodeType", loraNodeType);
            this.loraNodeType = loraNodeType;
            return this;
        }

        public Builder nickname(String nickname) {
            this.putQueryParameter("Nickname", nickname);
            this.nickname = nickname;
            return this;
        }

        public Builder pinCode(String pinCode) {
            this.putQueryParameter("PinCode", pinCode);
            this.pinCode = pinCode;
            return this;
        }

        public Builder productKey(String productKey) {
            this.putQueryParameter("ProductKey", productKey);
            this.productKey = productKey;
            return this;
        }

        public RegisterDeviceRequest build() {
            return new RegisterDeviceRequest(this);
        }
    }
}

