/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class UpdateParserDataSourceRequest
extends Request {
    @Query
    @NameInMap(value="DataSourceId")
    @Validation(required=true, maximum=9.999999999E9)
    private Long dataSourceId;
    @Query
    @NameInMap(value="Description")
    private String description;
    @Query
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Query
    @NameInMap(value="Name")
    @Validation(required=true)
    private String name;

    private UpdateParserDataSourceRequest(Builder builder) {
        super((Request.Builder)builder);
        this.dataSourceId = builder.dataSourceId;
        this.description = builder.description;
        this.iotInstanceId = builder.iotInstanceId;
        this.name = builder.name;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdateParserDataSourceRequest create() {
        return UpdateParserDataSourceRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Long getDataSourceId() {
        return this.dataSourceId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getName() {
        return this.name;
    }

    public static final class Builder
    extends Request.Builder<UpdateParserDataSourceRequest, Builder> {
        private Long dataSourceId;
        private String description;
        private String iotInstanceId;
        private String name;

        private Builder() {
        }

        private Builder(UpdateParserDataSourceRequest request) {
            super((Request)request);
            this.dataSourceId = request.dataSourceId;
            this.description = request.description;
            this.iotInstanceId = request.iotInstanceId;
            this.name = request.name;
        }

        public Builder dataSourceId(Long dataSourceId) {
            this.putQueryParameter("DataSourceId", dataSourceId);
            this.dataSourceId = dataSourceId;
            return this;
        }

        public Builder description(String description) {
            this.putQueryParameter("Description", description);
            this.description = description;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder name(String name) {
            this.putQueryParameter("Name", name);
            this.name = name;
            return this;
        }

        public UpdateParserDataSourceRequest build() {
            return new UpdateParserDataSourceRequest(this);
        }
    }
}

