/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.Map;

public class UpdateSpeechRequest
extends Request {
    @Body
    @NameInMap(value="EnableSoundCode")
    private Boolean enableSoundCode;
    @Body
    @NameInMap(value="IotInstanceId")
    private String iotInstanceId;
    @Body
    @NameInMap(value="ProjectCode")
    @Validation(required=true)
    private String projectCode;
    @Body
    @NameInMap(value="SoundCodeConfig")
    private Map<String, ?> soundCodeConfig;
    @Body
    @NameInMap(value="SpeechCode")
    @Validation(required=true)
    private String speechCode;
    @Body
    @NameInMap(value="SpeechRate")
    @Validation(maximum=500.0)
    private Integer speechRate;
    @Body
    @NameInMap(value="Voice")
    @Validation(required=true)
    private String voice;
    @Body
    @NameInMap(value="Volume")
    @Validation(maximum=100.0)
    private Integer volume;

    private UpdateSpeechRequest(Builder builder) {
        super((Request.Builder)builder);
        this.enableSoundCode = builder.enableSoundCode;
        this.iotInstanceId = builder.iotInstanceId;
        this.projectCode = builder.projectCode;
        this.soundCodeConfig = builder.soundCodeConfig;
        this.speechCode = builder.speechCode;
        this.speechRate = builder.speechRate;
        this.voice = builder.voice;
        this.volume = builder.volume;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdateSpeechRequest create() {
        return UpdateSpeechRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Boolean getEnableSoundCode() {
        return this.enableSoundCode;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getProjectCode() {
        return this.projectCode;
    }

    public Map<String, ?> getSoundCodeConfig() {
        return this.soundCodeConfig;
    }

    public String getSpeechCode() {
        return this.speechCode;
    }

    public Integer getSpeechRate() {
        return this.speechRate;
    }

    public String getVoice() {
        return this.voice;
    }

    public Integer getVolume() {
        return this.volume;
    }

    public static final class Builder
    extends Request.Builder<UpdateSpeechRequest, Builder> {
        private Boolean enableSoundCode;
        private String iotInstanceId;
        private String projectCode;
        private Map<String, ?> soundCodeConfig;
        private String speechCode;
        private Integer speechRate;
        private String voice;
        private Integer volume;

        private Builder() {
        }

        private Builder(UpdateSpeechRequest request) {
            super((Request)request);
            this.enableSoundCode = request.enableSoundCode;
            this.iotInstanceId = request.iotInstanceId;
            this.projectCode = request.projectCode;
            this.soundCodeConfig = request.soundCodeConfig;
            this.speechCode = request.speechCode;
            this.speechRate = request.speechRate;
            this.voice = request.voice;
            this.volume = request.volume;
        }

        public Builder enableSoundCode(Boolean enableSoundCode) {
            this.putBodyParameter("EnableSoundCode", enableSoundCode);
            this.enableSoundCode = enableSoundCode;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putBodyParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder projectCode(String projectCode) {
            this.putBodyParameter("ProjectCode", projectCode);
            this.projectCode = projectCode;
            return this;
        }

        public Builder soundCodeConfig(Map<String, ?> soundCodeConfig) {
            String soundCodeConfigShrink = this.shrink(soundCodeConfig, "SoundCodeConfig", "json");
            this.putBodyParameter("SoundCodeConfig", soundCodeConfigShrink);
            this.soundCodeConfig = soundCodeConfig;
            return this;
        }

        public Builder speechCode(String speechCode) {
            this.putBodyParameter("SpeechCode", speechCode);
            this.speechCode = speechCode;
            return this;
        }

        public Builder speechRate(Integer speechRate) {
            this.putBodyParameter("SpeechRate", speechRate);
            this.speechRate = speechRate;
            return this;
        }

        public Builder voice(String voice) {
            this.putBodyParameter("Voice", voice);
            this.voice = voice;
            return this;
        }

        public Builder volume(Integer volume) {
            this.putBodyParameter("Volume", volume);
            this.volume = volume;
            return this;
        }

        public UpdateSpeechRequest build() {
            return new UpdateSpeechRequest(this);
        }
    }
}

