/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.iot20180120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class WriteDevicesHotStorageDataRequest
extends Request {
    @Query
    @NameInMap(value="DeviceName")
    private String deviceName;
    @Query
    @NameInMap(value="IotId")
    private String iotId;
    @Query
    @NameInMap(value="IotInstanceId")
    @Validation(required=true)
    private String iotInstanceId;
    @Query
    @NameInMap(value="Items")
    @Validation(required=true)
    private String items;
    @Query
    @NameInMap(value="ProductKey")
    private String productKey;
    @Query
    @NameInMap(value="UserTopic")
    @Validation(required=true)
    private String userTopic;

    private WriteDevicesHotStorageDataRequest(Builder builder) {
        super((Request.Builder)builder);
        this.deviceName = builder.deviceName;
        this.iotId = builder.iotId;
        this.iotInstanceId = builder.iotInstanceId;
        this.items = builder.items;
        this.productKey = builder.productKey;
        this.userTopic = builder.userTopic;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static WriteDevicesHotStorageDataRequest create() {
        return WriteDevicesHotStorageDataRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getIotId() {
        return this.iotId;
    }

    public String getIotInstanceId() {
        return this.iotInstanceId;
    }

    public String getItems() {
        return this.items;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public String getUserTopic() {
        return this.userTopic;
    }

    public static final class Builder
    extends Request.Builder<WriteDevicesHotStorageDataRequest, Builder> {
        private String deviceName;
        private String iotId;
        private String iotInstanceId;
        private String items;
        private String productKey;
        private String userTopic;

        private Builder() {
        }

        private Builder(WriteDevicesHotStorageDataRequest request) {
            super((Request)request);
            this.deviceName = request.deviceName;
            this.iotId = request.iotId;
            this.iotInstanceId = request.iotInstanceId;
            this.items = request.items;
            this.productKey = request.productKey;
            this.userTopic = request.userTopic;
        }

        public Builder deviceName(String deviceName) {
            this.putQueryParameter("DeviceName", deviceName);
            this.deviceName = deviceName;
            return this;
        }

        public Builder iotId(String iotId) {
            this.putQueryParameter("IotId", iotId);
            this.iotId = iotId;
            return this;
        }

        public Builder iotInstanceId(String iotInstanceId) {
            this.putQueryParameter("IotInstanceId", iotInstanceId);
            this.iotInstanceId = iotInstanceId;
            return this;
        }

        public Builder items(String items) {
            this.putQueryParameter("Items", items);
            this.items = items;
            return this;
        }

        public Builder productKey(String productKey) {
            this.putQueryParameter("ProductKey", productKey);
            this.productKey = productKey;
            return this;
        }

        public Builder userTopic(String userTopic) {
            this.putQueryParameter("UserTopic", userTopic);
            this.userTopic = userTopic;
            return this;
        }

        public WriteDevicesHotStorageDataRequest build() {
            return new WriteDevicesHotStorageDataRequest(this);
        }
    }
}

