/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.pai_dsw20220101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListEcsSpecsRequest
extends Request {
    @Query
    @NameInMap(value="AcceleratorType")
    @Validation(required=true)
    private String acceleratorType;
    @Query
    @NameInMap(value="Order")
    private String order;
    @Query
    @NameInMap(value="PageNumber")
    private Long pageNumber;
    @Query
    @NameInMap(value="PageSize")
    private Long pageSize;
    @Query
    @NameInMap(value="ResourceType")
    private String resourceType;
    @Query
    @NameInMap(value="SortBy")
    private String sortBy;

    private ListEcsSpecsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.acceleratorType = builder.acceleratorType;
        this.order = builder.order;
        this.pageNumber = builder.pageNumber;
        this.pageSize = builder.pageSize;
        this.resourceType = builder.resourceType;
        this.sortBy = builder.sortBy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListEcsSpecsRequest create() {
        return ListEcsSpecsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAcceleratorType() {
        return this.acceleratorType;
    }

    public String getOrder() {
        return this.order;
    }

    public Long getPageNumber() {
        return this.pageNumber;
    }

    public Long getPageSize() {
        return this.pageSize;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public static final class Builder
    extends Request.Builder<ListEcsSpecsRequest, Builder> {
        private String acceleratorType;
        private String order;
        private Long pageNumber;
        private Long pageSize;
        private String resourceType;
        private String sortBy;

        private Builder() {
        }

        private Builder(ListEcsSpecsRequest request) {
            super((Request)request);
            this.acceleratorType = request.acceleratorType;
            this.order = request.order;
            this.pageNumber = request.pageNumber;
            this.pageSize = request.pageSize;
            this.resourceType = request.resourceType;
            this.sortBy = request.sortBy;
        }

        public Builder acceleratorType(String acceleratorType) {
            this.putQueryParameter("AcceleratorType", acceleratorType);
            this.acceleratorType = acceleratorType;
            return this;
        }

        public Builder order(String order) {
            this.putQueryParameter("Order", order);
            this.order = order;
            return this;
        }

        public Builder pageNumber(Long pageNumber) {
            this.putQueryParameter("PageNumber", pageNumber);
            this.pageNumber = pageNumber;
            return this;
        }

        public Builder pageSize(Long pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.putQueryParameter("ResourceType", resourceType);
            this.resourceType = resourceType;
            return this;
        }

        public Builder sortBy(String sortBy) {
            this.putQueryParameter("SortBy", sortBy);
            this.sortBy = sortBy;
            return this;
        }

        public ListEcsSpecsRequest build() {
            return new ListEcsSpecsRequest(this);
        }
    }
}

