/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.kms.secretsmanager.client.service;

import com.aliyuncs.kms.secretsmanager.client.exception.CacheSecretException;
import com.aliyuncs.kms.secretsmanager.client.model.CacheSecretInfo;
import com.aliyuncs.kms.secretsmanager.client.model.SecretInfo;
import com.aliyuncs.kms.secretsmanager.client.service.RefreshSecretStrategy;
import com.aliyuncs.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.util.Map;

public class DefaultRefreshSecretStrategy
implements RefreshSecretStrategy {
    private static final Gson gson = new Gson();
    private String jsonTTLPropertyName;

    public DefaultRefreshSecretStrategy() {
    }

    public DefaultRefreshSecretStrategy(String jsonTTLPropertyName) {
        this.jsonTTLPropertyName = jsonTTLPropertyName;
    }

    @Override
    public void init() throws CacheSecretException {
    }

    @Override
    public long getNextExecuteTime(String secretName, long ttl, long offsetTimestamp) {
        long now = System.currentTimeMillis();
        if (ttl + offsetTimestamp > now) {
            return ttl + offsetTimestamp;
        }
        return now + ttl;
    }

    @Override
    public long parseNextExecuteTime(CacheSecretInfo cacheSecretInfo) {
        SecretInfo secretInfo = cacheSecretInfo.getSecretInfo();
        long ttl = this.parseTTL(secretInfo);
        if (ttl <= 0L) {
            return ttl;
        }
        return this.getNextExecuteTime(secretInfo.getSecretName(), ttl, cacheSecretInfo.getRefreshTimestamp());
    }

    @Override
    public long parseTTL(SecretInfo secretInfo) {
        if (StringUtils.isEmpty((CharSequence)this.jsonTTLPropertyName)) {
            return -1L;
        }
        try {
            Map map = (Map)gson.fromJson(secretInfo.getSecretValue(), Map.class);
            if (map.get(this.jsonTTLPropertyName) == null) {
                return -1L;
            }
            return ((Double)map.get(this.jsonTTLPropertyName)).longValue();
        }
        catch (JsonSyntaxException ignore) {
            return -1L;
        }
    }

    @Override
    public void close() throws IOException {
    }
}

