/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.kms.secretsmanager.client.service;

import com.aliyun.dkms.gcs.openapi.models.Config;
import com.aliyun.kms.KmsTransferAcsClient;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.auth.AlibabaCloudCredentialsProvider;
import com.aliyuncs.auth.InstanceProfileCredentialsProvider;
import com.aliyuncs.auth.STSAssumeRoleSessionCredentialsProvider;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.HttpClientConfig;
import com.aliyuncs.kms.model.v20160120.GetSecretValueRequest;
import com.aliyuncs.kms.model.v20160120.GetSecretValueResponse;
import com.aliyuncs.kms.secretsmanager.client.exception.CacheSecretException;
import com.aliyuncs.kms.secretsmanager.client.model.CredentialsProperties;
import com.aliyuncs.kms.secretsmanager.client.model.DKmsConfig;
import com.aliyuncs.kms.secretsmanager.client.model.RegionInfo;
import com.aliyuncs.kms.secretsmanager.client.service.BackoffStrategy;
import com.aliyuncs.kms.secretsmanager.client.service.BaseSecretManagerClientBuilder;
import com.aliyuncs.kms.secretsmanager.client.service.FullJitterBackoffStrategy;
import com.aliyuncs.kms.secretsmanager.client.service.SecretManagerClient;
import com.aliyuncs.kms.secretsmanager.client.service.UserAgentManager;
import com.aliyuncs.kms.secretsmanager.client.utils.BackoffUtils;
import com.aliyuncs.kms.secretsmanager.client.utils.ClientKeyUtils;
import com.aliyuncs.kms.secretsmanager.client.utils.CommonLogger;
import com.aliyuncs.kms.secretsmanager.client.utils.CredentialsPropertiesUtils;
import com.aliyuncs.kms.secretsmanager.client.utils.CredentialsProviderUtils;
import com.aliyuncs.kms.secretsmanager.client.utils.KmsEndpointUtils;
import com.aliyuncs.kms.secretsmanager.client.utils.PingUtils;
import com.aliyuncs.kms.secretsmanager.client.utils.TypeUtils;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class DefaultSecretManagerClientBuilder
extends BaseSecretManagerClientBuilder {
    private List<RegionInfo> regionInfos = new ArrayList<RegionInfo>();
    private Map<RegionInfo, DKmsConfig> dKmsConfigsMap = new HashMap<RegionInfo, DKmsConfig>();
    private AlibabaCloudCredentialsProvider provider;
    private BackoffStrategy backoffStrategy;
    private String customConfigFile;

    public DefaultSecretManagerClientBuilder withToken(String tokenId, String token) {
        this.provider = CredentialsProviderUtils.withToken(tokenId, token);
        return this;
    }

    public DefaultSecretManagerClientBuilder withAccessKey(String accessKeyId, String accessKeySecret) {
        this.provider = CredentialsProviderUtils.withAccessKey(accessKeyId, accessKeySecret);
        return this;
    }

    public DefaultSecretManagerClientBuilder withCredentialsProvider(AlibabaCloudCredentialsProvider provider) {
        this.provider = provider;
        return this;
    }

    public DefaultSecretManagerClientBuilder addRegion(String regionId) {
        return this.addRegion(new RegionInfo(regionId));
    }

    public DefaultSecretManagerClientBuilder addRegion(RegionInfo regionInfo) {
        this.regionInfos.add(regionInfo);
        return this;
    }

    public DefaultSecretManagerClientBuilder withRegion(String ... regionIds) {
        for (String regionId : regionIds) {
            this.addRegion(new RegionInfo(regionId));
        }
        return this;
    }

    public DefaultSecretManagerClientBuilder withBackoffStrategy(BackoffStrategy backoffStrategy) {
        this.backoffStrategy = backoffStrategy;
        return this;
    }

    public DefaultSecretManagerClientBuilder addDKmsConfig(DKmsConfig dKmsConfig) {
        if (StringUtils.isEmpty((CharSequence)dKmsConfig.getRegionId()) || StringUtils.isEmpty((CharSequence)dKmsConfig.getEndpoint())) {
            throw new IllegalArgumentException("param[regionId or endpoint] is null");
        }
        RegionInfo regionInfo = new RegionInfo();
        regionInfo.setKmsType(1);
        regionInfo.setRegionId(dKmsConfig.getRegionId());
        regionInfo.setEndpoint(dKmsConfig.getEndpoint());
        this.dKmsConfigsMap.put(regionInfo, dKmsConfig);
        this.regionInfos.add(regionInfo);
        return this;
    }

    public DefaultSecretManagerClientBuilder withCustomConfigFile(String customConfigFile) {
        this.customConfigFile = customConfigFile;
        return this;
    }

    @Override
    public SecretManagerClient build() throws CacheSecretException {
        DefaultSecretManagerClient client = new DefaultSecretManagerClient();
        return client;
    }

    private List<RegionInfo> sortRegionInfos(List<RegionInfo> regionInfos) {
        ArrayList<RegionInfoExtend> regionInfoExtends = new ArrayList<RegionInfoExtend>();
        for (RegionInfo regionInfo : regionInfos) {
            double pingDelay = !StringUtils.isEmpty((CharSequence)regionInfo.getEndpoint()) ? PingUtils.ping(regionInfo.getEndpoint()) : (regionInfo.getVpc() ? PingUtils.ping(KmsEndpointUtils.getVPCEndpoint(regionInfo.getRegionId())) : PingUtils.ping(KmsEndpointUtils.getEndPoint(regionInfo.getRegionId())));
            RegionInfoExtend regionInfoExtend2 = new RegionInfoExtend(regionInfo);
            regionInfoExtend2.setReachable(pingDelay >= 0.0);
            regionInfoExtend2.setEscaped(pingDelay >= 0.0 ? pingDelay : Double.MAX_VALUE);
            regionInfoExtends.add(regionInfoExtend2);
        }
        return regionInfoExtends.stream().sorted(Comparator.comparing(regionInfoExtend -> !regionInfoExtend.getReachable()).thenComparing(RegionInfoExtend::getEscaped)).map(regionInfoExtend -> new RegionInfo(regionInfoExtend.getRegionId(), regionInfoExtend.getVpc(), regionInfoExtend.getEndpoint(), regionInfoExtend.getKmsType())).collect(Collectors.toList());
    }

    class RegionInfoExtend {
        private boolean reachable;
        private double escaped;
        private String regionId;
        private boolean vpc;
        private String endpoint;
        private int kmsType;

        public RegionInfoExtend(RegionInfo regionInfo) {
            this.regionId = regionInfo.getRegionId();
            this.vpc = regionInfo.getVpc();
            this.endpoint = regionInfo.getEndpoint();
            this.kmsType = regionInfo.getKmsType();
        }

        public String getRegionId() {
            return this.regionId;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public boolean getVpc() {
            return this.vpc;
        }

        public boolean getReachable() {
            return this.reachable;
        }

        public void setReachable(boolean reachable) {
            this.reachable = reachable;
        }

        public double getEscaped() {
            return this.escaped;
        }

        public void setEscaped(double escaped) {
            this.escaped = escaped;
        }

        public int getKmsType() {
            return this.kmsType;
        }
    }

    class DefaultSecretManagerClient
    implements SecretManagerClient {
        private ScheduledThreadPoolExecutor pool = new ScheduledThreadPoolExecutor(5);
        private Map<RegionInfo, DefaultAcsClient> clientMap = new HashMap<RegionInfo, DefaultAcsClient>();

        DefaultSecretManagerClient() {
        }

        @Override
        public GetSecretValueResponse getSecretValue(GetSecretValueRequest req) throws ClientException {
            ArrayList<Future<GetSecretValueResponse>> futures = new ArrayList<Future<GetSecretValueResponse>>();
            CountDownLatch count = null;
            AtomicInteger finished = null;
            for (int i = 0; i < DefaultSecretManagerClientBuilder.this.regionInfos.size(); ++i) {
                if (i == 0) {
                    try {
                        return this.getSecretValue((RegionInfo)DefaultSecretManagerClientBuilder.this.regionInfos.get(i), req);
                    }
                    catch (ClientException e) {
                        CommonLogger.getCommonLogger("CacheClient").errorf("action:getSecretValue", new Object[]{e});
                        if (!BackoffUtils.judgeNeedRecoveryException(e)) {
                            throw e;
                        }
                        count = new CountDownLatch(1);
                        finished = new AtomicInteger(DefaultSecretManagerClientBuilder.this.regionInfos.size());
                    }
                }
                GetSecretValueRequest request = new GetSecretValueRequest();
                request.setSecretName(req.getSecretName());
                request.setVersionStage(req.getVersionStage());
                request.setFetchExtendedConfig(Boolean.valueOf(true));
                request.setAcceptFormat(FormatType.XML);
                Future<GetSecretValueResponse> future = this.pool.submit(new RetryGetSecretValueTask(request, (RegionInfo)DefaultSecretManagerClientBuilder.this.regionInfos.get(i), count, finished));
                futures.add(future);
            }
            GetSecretValueResponse getSecretValueResponse = null;
            try {
                count.await(600000L, TimeUnit.MILLISECONDS);
                for (Future<GetSecretValueResponse> future : futures) {
                    try {
                        if (!future.isDone()) {
                            future.cancel(true);
                            continue;
                        }
                        getSecretValueResponse = (GetSecretValueResponse)future.get();
                        if (getSecretValueResponse == null) continue;
                        GetSecretValueResponse getSecretValueResponse2 = getSecretValueResponse;
                        return getSecretValueResponse2;
                    }
                    catch (InterruptedException | ExecutionException e) {
                        CommonLogger.getCommonLogger("CacheClient").errorf("action:asyncGetSecretValue", e);
                    }
                }
            }
            catch (InterruptedException e) {
                CommonLogger.getCommonLogger("CacheClient").errorf("action:retryGetSecretValueTask", e);
                throw new ClientException((Throwable)e);
            }
            finally {
                if (count.getCount() > 0L) {
                    count.countDown();
                }
            }
            throw new ClientException("SDK.ReadTimeout", String.format("refreshSecretTask fail with secretName[%s]", req.getSecretName()));
        }

        @Override
        public void close() throws IOException {
            if (this.pool != null) {
                this.pool.shutdown();
            }
            if (this.clientMap != null && this.clientMap.size() > 0) {
                for (Map.Entry<RegionInfo, DefaultAcsClient> clientEntry : this.clientMap.entrySet()) {
                    try {
                        DefaultAcsClient client = clientEntry.getValue();
                        client.getHttpClient().close();
                    }
                    catch (Exception exception) {}
                }
            }
        }

        public GetSecretValueResponse getSecretValue(RegionInfo regionInfo, GetSecretValueRequest req) throws ClientException {
            return (GetSecretValueResponse)this.getClient(regionInfo).getAcsResponse((AcsRequest)req);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DefaultAcsClient getClient(RegionInfo regionInfo) {
            if (this.clientMap.get(regionInfo) != null) {
                return this.clientMap.get(regionInfo);
            }
            RegionInfo regionInfo2 = regionInfo;
            synchronized (regionInfo2) {
                if (this.clientMap.containsKey(regionInfo)) {
                    return this.clientMap.get(regionInfo);
                }
                if (regionInfo.getKmsType() == 1) {
                    this.clientMap.put(regionInfo, this.buildDKMSTransferClient(regionInfo));
                } else {
                    this.clientMap.put(regionInfo, this.buildKMSClient(regionInfo));
                }
            }
            return this.clientMap.get(regionInfo);
        }

        private DefaultAcsClient buildKMSClient(RegionInfo regionInfo) {
            DefaultProfile profile = DefaultProfile.getProfile((String)regionInfo.getRegionId());
            if (!StringUtils.isEmpty((CharSequence)regionInfo.getEndpoint())) {
                DefaultProfile.addEndpoint((String)regionInfo.getRegionId(), (String)"kms", (String)regionInfo.getEndpoint());
            } else if (regionInfo.getVpc()) {
                DefaultProfile.addEndpoint((String)regionInfo.getRegionId(), (String)"kms", (String)KmsEndpointUtils.getVPCEndpoint(regionInfo.getRegionId()));
            }
            HttpClientConfig clientConfig = HttpClientConfig.getDefault();
            clientConfig.setIgnoreSSLCerts(true);
            profile.setHttpClientConfig(clientConfig);
            DefaultAcsClient acsClient = new DefaultAcsClient((IClientProfile)profile, DefaultSecretManagerClientBuilder.this.provider);
            acsClient.appendUserAgent(UserAgentManager.getUserAgent(), UserAgentManager.getProjectVersion());
            return acsClient;
        }

        private DefaultAcsClient buildDKMSTransferClient(RegionInfo regionInfo) {
            DefaultProfile profile = DefaultProfile.getProfile((String)regionInfo.getRegionId(), (String)"PRETEND_AK", (String)"PRETEND_SK");
            DKmsConfig dKmsConfig = (DKmsConfig)((Object)DefaultSecretManagerClientBuilder.this.dKmsConfigsMap.get(regionInfo));
            if (dKmsConfig == null) {
                throw new IllegalArgumentException("Unrecognized regionId");
            }
            DKmsConfig config = dKmsConfig;
            config.setRegionId(regionInfo.getRegionId());
            config.setEndpoint(regionInfo.getEndpoint());
            config.setPassword(dKmsConfig.getPassword());
            config.setUserAgent(UserAgentManager.getUserAgent() + "/" + UserAgentManager.getProjectVersion());
            HttpClientConfig clientConfig = HttpClientConfig.getDefault();
            clientConfig.setIgnoreSSLCerts(dKmsConfig.getIgnoreSslCerts());
            profile.setHttpClientConfig(clientConfig);
            return new KmsTransferAcsClient((IClientProfile)profile, (Config)config);
        }

        @Override
        public void init() throws CacheSecretException {
            this.initFromConfigFile();
            this.initFromEnv();
            this.checkConfigAndEnv();
            UserAgentManager.registerUserAgent("alibabacloud-secretsmanager-java", 0, "1.3.7");
            if (DefaultSecretManagerClientBuilder.this.backoffStrategy == null) {
                DefaultSecretManagerClientBuilder.this.backoffStrategy = new FullJitterBackoffStrategy();
            }
            DefaultSecretManagerClientBuilder.this.backoffStrategy.init();
            if (DefaultSecretManagerClientBuilder.this.regionInfos.size() > 1) {
                DefaultSecretManagerClientBuilder.this.regionInfos = DefaultSecretManagerClientBuilder.this.sortRegionInfos(DefaultSecretManagerClientBuilder.this.regionInfos);
            }
        }

        private void checkConfigAndEnv() {
            if (DefaultSecretManagerClientBuilder.this.dKmsConfigsMap.isEmpty() && DefaultSecretManagerClientBuilder.this.provider == null) {
                throw new IllegalArgumentException("The configuration of the secrets manager client must be needed, please config the configuration file or related environment variable, or set your credentials provider.");
            }
            if (DefaultSecretManagerClientBuilder.this.regionInfos.isEmpty()) {
                throw new IllegalArgumentException("The param[regionInfo] is needed");
            }
        }

        private void initFromEnv() throws CacheSecretException {
            Map<String, String> envMap = System.getenv();
            this.initCredentialsProviderFromEnv(envMap);
            this.initDkmsInstancesFromEnv(envMap);
            this.initKmsRegionsFromEnv(envMap);
        }

        private void initCredentialsProviderFromEnv(Map<String, String> envMap) {
            String credentialsType = envMap.get("credentials_type");
            if (!StringUtils.isEmpty((CharSequence)credentialsType)) {
                String accessKeyId = envMap.get("credentials_access_key_id");
                String accessSecret = envMap.get("credentials_access_secret");
                AlibabaCloudCredentialsProvider provider = null;
                switch (credentialsType) {
                    case "ak": {
                        this.checkEnvParamNull(accessKeyId, "credentials_access_key_id");
                        this.checkEnvParamNull(accessSecret, "credentials_access_secret");
                        provider = CredentialsProviderUtils.withAccessKey(accessKeyId, accessSecret);
                        break;
                    }
                    case "token": {
                        String credentialsAccessTokenId = envMap.get("credentials_access_token_id");
                        String credentialsAccessToken = envMap.get("credentials_access_token");
                        this.checkEnvParamNull(credentialsAccessTokenId, "credentials_access_token_id");
                        this.checkEnvParamNull(credentialsAccessToken, "credentials_access_token");
                        provider = CredentialsProviderUtils.withToken(credentialsAccessTokenId, credentialsAccessToken);
                        break;
                    }
                    case "sts": 
                    case "ram_role": {
                        String roleSessionName = envMap.get("credentials_role_session_name");
                        String roleArn = envMap.get("credentials_role_arn");
                        String policy = envMap.get("credentials_policy");
                        this.checkEnvParamNull(accessKeyId, "credentials_access_key_id");
                        this.checkEnvParamNull(accessSecret, "credentials_access_secret");
                        this.checkEnvParamNull(roleSessionName, "credentials_role_session_name");
                        this.checkEnvParamNull(roleArn, "credentials_role_arn");
                        provider = new STSAssumeRoleSessionCredentialsProvider(accessKeyId, accessSecret, roleSessionName, roleArn, ((RegionInfo)DefaultSecretManagerClientBuilder.this.regionInfos.get(0)).getRegionId(), policy);
                        break;
                    }
                    case "ecs_ram_role": {
                        String roleName = envMap.get("credentials_role_name");
                        this.checkEnvParamNull(roleName, "credentials_role_name");
                        provider = new InstanceProfileCredentialsProvider(roleName);
                        break;
                    }
                    case "client_key": {
                        String password = ClientKeyUtils.getPassword(envMap, "client_key_password_from_env_variable", "client_key_password_from_file_path");
                        String privateKeyPath = envMap.get("client_key_private_key_path");
                        this.checkEnvParamNull(privateKeyPath, "client_key_private_key_path");
                        provider = CredentialsProviderUtils.getCredentialsProvider(privateKeyPath, password);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("env param[%s] is illegal", "credentials_type"));
                    }
                }
                if (provider != null) {
                    DefaultSecretManagerClientBuilder.this.withCredentialsProvider(provider);
                }
            }
        }

        private void initDkmsInstancesFromEnv(Map<String, String> envMap) {
            ArrayList dKmsConfigs = new ArrayList();
            String configJson = envMap.get("cache_client_dkms_config_info");
            if (!StringUtils.isEmpty((CharSequence)configJson)) {
                try {
                    Type configListType = new TypeToken<ArrayList<DKmsConfig>>(){}.getType();
                    dKmsConfigs.addAll((Collection)new Gson().fromJson(configJson, configListType));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("env param[%s] is illegal", "cache_client_dkms_config_info"));
                }
            }
            for (DKmsConfig dKmsConfig : dKmsConfigs) {
                RegionInfo regionInfo = new RegionInfo();
                if (StringUtils.isEmpty((CharSequence)dKmsConfig.getRegionId()) || StringUtils.isEmpty((CharSequence)dKmsConfig.getEndpoint())) {
                    throw new IllegalArgumentException("init env fail,cause of cache_client_dkms_config_info param[regionId or endpoint] is null");
                }
                regionInfo.setRegionId(dKmsConfig.getRegionId());
                regionInfo.setEndpoint(dKmsConfig.getEndpoint());
                regionInfo.setKmsType(1);
                if (!StringUtils.isEmpty((CharSequence)dKmsConfig.getPasswordFromFilePath())) {
                    dKmsConfig.setPassword(ClientKeyUtils.readPasswordFile(dKmsConfig.getPasswordFromFilePath()));
                } else {
                    dKmsConfig.setPassword(ClientKeyUtils.getPassword(envMap, dKmsConfig.getPasswordFromEnvVariable(), dKmsConfig.getPasswordFromFilePathName()));
                }
                DefaultSecretManagerClientBuilder.this.dKmsConfigsMap.put(regionInfo, dKmsConfig);
                DefaultSecretManagerClientBuilder.this.regionInfos.add(regionInfo);
            }
        }

        private void initKmsRegionsFromEnv(Map<String, String> envMap) {
            String regionJson = envMap.get("cache_client_region_id");
            if (!StringUtils.isEmpty((CharSequence)regionJson)) {
                try {
                    List configList = (List)new Gson().fromJson(regionJson, List.class);
                    for (Map map : configList) {
                        RegionInfo regionInfo = new RegionInfo();
                        regionInfo.setRegionId(TypeUtils.parseString(map.get("regionId")));
                        regionInfo.setEndpoint(TypeUtils.parseString(map.get("endpoint")));
                        regionInfo.setVpc(TypeUtils.parseBoolean(map.get("vpc")));
                        DefaultSecretManagerClientBuilder.this.regionInfos.add(regionInfo);
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("env param[%s] is illegal", "cache_client_region_id"));
                }
            }
        }

        private void initFromConfigFile() {
            CredentialsProperties credentialsProperties = CredentialsPropertiesUtils.loadCredentialsProperties(DefaultSecretManagerClientBuilder.this.customConfigFile);
            if (credentialsProperties != null) {
                if (credentialsProperties.getProvider() != null) {
                    AlibabaCloudCredentialsProvider provider = credentialsProperties.getProvider();
                    DefaultSecretManagerClientBuilder.this.withCredentialsProvider(provider);
                }
                DefaultSecretManagerClientBuilder.this.regionInfos.addAll(credentialsProperties.getRegionInfoList());
                if (credentialsProperties.getDkmsConfigsMap() != null) {
                    DefaultSecretManagerClientBuilder.this.dKmsConfigsMap.putAll(credentialsProperties.getDkmsConfigsMap());
                }
            }
        }

        private void checkEnvParamNull(String param, String paramName) {
            if (StringUtils.isEmpty((CharSequence)param)) {
                throw new IllegalArgumentException(String.format("env param[%s] is required", paramName));
            }
        }

        class RetryGetSecretValueTask
        implements Callable<GetSecretValueResponse> {
            private final GetSecretValueRequest req;
            private final RegionInfo regionInfo;
            private final CountDownLatch countDownLatch;
            private final AtomicInteger finished;

            public RetryGetSecretValueTask(GetSecretValueRequest req, RegionInfo regionInfo, CountDownLatch countDownLatch, AtomicInteger finished) {
                this.req = req;
                this.regionInfo = regionInfo;
                this.countDownLatch = countDownLatch;
                this.finished = finished;
            }

            @Override
            public GetSecretValueResponse call() throws Exception {
                try {
                    GetSecretValueResponse resp = this.retryGetSecretValue(this.req, this.regionInfo);
                    this.countDownLatch.countDown();
                    GetSecretValueResponse getSecretValueResponse = resp;
                    return getSecretValueResponse;
                }
                catch (Exception e) {
                    CommonLogger.getCommonLogger("CacheClient").errorf("action:retryGetSecretValueRun", e);
                    GetSecretValueResponse getSecretValueResponse = null;
                    return getSecretValueResponse;
                }
                finally {
                    if (this.finished.decrementAndGet() == 0) {
                        this.countDownLatch.countDown();
                    }
                }
            }

            private GetSecretValueResponse retryGetSecretValue(GetSecretValueRequest req, RegionInfo regionInfo) throws ClientException {
                int retryTimes = 0;
                while (this.countDownLatch.getCount() != 0L) {
                    long waitTimeExponential = DefaultSecretManagerClientBuilder.this.backoffStrategy.getWaitTimeExponential(retryTimes);
                    if (waitTimeExponential < 0L) {
                        throw new ClientException("SDK.ReadTimeout", "Times limit exceeded");
                    }
                    try {
                        Thread.sleep(waitTimeExponential);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    try {
                        return DefaultSecretManagerClient.this.getSecretValue(regionInfo, req);
                    }
                    catch (ClientException e) {
                        CommonLogger.getCommonLogger("CacheClient").errorf("action:getSecretValue regionInfo:{}", new Object[]{regionInfo, e});
                        if (!BackoffUtils.judgeNeedRecoveryException(e)) {
                            throw e;
                        }
                        ++retryTimes;
                        continue;
                    }
                    break;
                }
                return null;
            }
        }
    }
}

