/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.kms.secretsmanager.client.service;

import com.aliyuncs.kms.secretsmanager.client.exception.CacheSecretException;
import com.aliyuncs.kms.secretsmanager.client.service.BackoffStrategy;

public class FullJitterBackoffStrategy
implements BackoffStrategy {
    private Long retryMaxAttempts;
    private Long retryInitialIntervalMills;
    private Long capacity;

    public FullJitterBackoffStrategy() {
    }

    public FullJitterBackoffStrategy(long retryMaxAttempts, long retryInitialIntervalMills, long capacity) {
        this.retryMaxAttempts = retryMaxAttempts;
        this.retryInitialIntervalMills = retryInitialIntervalMills;
        this.capacity = capacity;
    }

    @Override
    public void init() throws CacheSecretException {
        this.retryMaxAttempts = this.retryMaxAttempts == null ? (this.retryMaxAttempts = Long.valueOf(5L)) : this.retryMaxAttempts;
        this.retryInitialIntervalMills = this.retryInitialIntervalMills == null ? (this.retryInitialIntervalMills = Long.valueOf(2000L)) : this.retryInitialIntervalMills;
        this.capacity = this.capacity == null ? (this.capacity = Long.valueOf(10000L)) : this.capacity;
    }

    @Override
    public long getWaitTimeExponential(int retryTimes) {
        if ((long)retryTimes > this.retryMaxAttempts) {
            return -1L;
        }
        return Math.min(this.capacity, (long)(Math.pow(2.0, retryTimes) * (double)this.retryInitialIntervalMills.longValue()));
    }
}

