/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.kms.secretsmanager.client.utils;

import com.aliyuncs.kms.secretsmanager.client.utils.CommonLogger;
import com.aliyuncs.utils.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PingUtils {
    private static Pattern unixPattern = Pattern.compile("=(\\d+)(.\\d+)? ms", 2);
    private static Pattern windowsPattern = Pattern.compile("=(\\d+)(.\\d+)?ms", 2);

    private PingUtils() {
    }

    public static double ping(String addr) {
        if (PingUtils.isWindows()) {
            return PingUtils.systemPing("ping -n 1 ", addr, windowsPattern);
        }
        return PingUtils.systemPing("ping -c 1 ", addr, unixPattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static double systemPing(String pingCommand, String addr, Pattern pattern) {
        BufferedReader in = null;
        try {
            Process process = Runtime.getRuntime().exec(pingCommand + addr);
            if (process == null) {
                double d = -1.0;
                return d;
            }
            in = new BufferedReader(new InputStreamReader(process.getInputStream()));
            StringBuffer sb = new StringBuffer();
            String line = null;
            while ((line = in.readLine()) != null) {
                sb.append(line + "\n");
            }
            boolean finished = process.waitFor(2L, TimeUnit.SECONDS);
            if (!finished) {
                double d = -1.0;
                return d;
            }
            double d = PingUtils.getCheckResult(sb.toString(), pattern);
            return d;
        }
        catch (IOException | InterruptedException ignore) {
            CommonLogger.getCommonLogger("CacheClient").errorf("action:ping", ignore);
            return -1.0;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static double getCheckResult(String line, Pattern pattern) {
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            if (matcher.groupCount() == 2) {
                if (StringUtils.isEmpty((CharSequence)matcher.group(2))) {
                    return Double.parseDouble(matcher.group(1));
                }
                return Double.parseDouble(matcher.group(1) + matcher.group(2));
            }
            return Double.parseDouble(matcher.group(1));
        }
        return -1.0;
    }

    private static boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("win") >= 0;
    }
}

