/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.gateway.oss.internal.async;

import darabonba.core.TeaResponseHandler;
import darabonba.core.async.AsyncResponseHandler;
import java.nio.ByteBuffer;
import java.util.zip.Checksum;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class CheckedAsyncResponseHandler
implements AsyncResponseHandler<Object, Object> {
    protected volatile AsyncResponseHandler<?, ?> handler;
    private Checksum cksum;

    public CheckedAsyncResponseHandler(TeaResponseHandler handler, Checksum cksum) {
        this.handler = (AsyncResponseHandler)handler;
        this.cksum = cksum;
    }

    public void onStream(Publisher<ByteBuffer> publisher) {
        this.cksum.reset();
        CheckSumProcessor proc = new CheckSumProcessor(this.cksum);
        this.handler.onStream((Publisher)proc);
        publisher.subscribe((Subscriber)proc);
    }

    public void onError(Throwable throwable) {
        if (this.handler != null) {
            this.handler.onError(throwable);
        }
    }

    public Object transform(Object response) {
        return null;
    }

    public Checksum getChecksum() {
        return this.cksum;
    }

    static class CheckSumProcessor
    implements Processor<ByteBuffer, ByteBuffer> {
        protected volatile Subscriber<? super ByteBuffer> subscriber;
        protected Checksum cksum;

        CheckSumProcessor(Checksum cksum) {
            this.cksum = cksum;
        }

        public void subscribe(Subscriber<? super ByteBuffer> subscriber) {
            this.subscriber = subscriber;
        }

        public void onSubscribe(Subscription subscription) {
            this.cksum.reset();
            this.subscriber.onSubscribe(subscription);
        }

        public void onNext(ByteBuffer byteBuffer) {
            if (byteBuffer.hasRemaining()) {
                this.cksum.update(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            }
            this.subscriber.onNext((Object)byteBuffer);
        }

        public void onError(Throwable throwable) {
            this.subscriber.onError(throwable);
        }

        public void onComplete() {
            this.subscriber.onComplete();
        }
    }
}

