/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.gateway.oss.policy.retry.conditions;

import com.aliyun.sdk.gateway.oss.exception.OSSServerException;
import darabonba.core.policy.retry.RetryPolicyContext;
import darabonba.core.policy.retry.conditions.RetryCondition;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

public final class RetryOnErrorCodeCondition
implements RetryCondition {
    private final Set<String> errorCodes;

    private RetryOnErrorCodeCondition(Set<String> retryableErrorCodes) {
        this.errorCodes = retryableErrorCodes;
    }

    public boolean shouldRetry(RetryPolicyContext context) {
        if (context.exception() instanceof OSSServerException) {
            OSSServerException exception = (OSSServerException)((Object)context.exception());
            return this.errorCodes.contains(exception.errorDetails().errorCode());
        }
        return false;
    }

    public static RetryOnErrorCodeCondition create(String ... errorCodes) {
        return new RetryOnErrorCodeCondition(Arrays.stream(errorCodes).collect(Collectors.toSet()));
    }

    public static RetryOnErrorCodeCondition create(Set<String> errorCodes) {
        return new RetryOnErrorCodeCondition(errorCodes);
    }
}

