package com.aliyun.sdk.gateway.pop.interceptor.configuration;

import com.aliyun.core.logging.ClientLogger;
import com.aliyun.core.utils.AttributeMap;
import com.aliyun.core.utils.StringUtils;
import com.aliyun.sdk.gateway.pop.exception.PopClientException;
import darabonba.core.EndpointType;
import darabonba.core.TeaConfiguration;
import darabonba.core.TeaRequest;
import darabonba.core.exception.TeaException;
import darabonba.core.interceptor.ConfigurationInterceptor;
import darabonba.core.interceptor.InterceptorContext;

public class EndpointInterceptor implements ConfigurationInterceptor {
    private final ClientLogger logger = new ClientLogger(EndpointInterceptor.class);

    protected final static class EndpointRule {
        public final static String Regional = "regional";
        public final static String SEPARATOR = "-";
    }

    @Override
    public TeaConfiguration modifyConfiguration(InterceptorContext context, AttributeMap attributes) {
        logger.info("Endpoint pre-process begin.");
        TeaRequest request = context.teaRequest();
        TeaConfiguration configuration = context.configuration();
        if (!StringUtils.isEmpty(configuration.endpoint())) {
            return configuration;
        }
        if (!StringUtils.isEmpty(configuration.region())
                && !request.endpointMap().isEmpty()
                && request.endpointMap().containsKey(configuration.region())) {
            configuration.setEndpoint(request.endpointMap().get(configuration.region()));
            return configuration;
        }
        String endpointType = StringUtils.EMPTY;
        if (!StringUtils.isEmpty(configuration.endpointType()) && !configuration.endpointType().equals(EndpointType.PUBLIC)) {
            endpointType = EndpointRule.SEPARATOR + configuration.endpointType();
        }
        if (request.endpointRule().equals(EndpointRule.Regional)) {
            if (StringUtils.isEmpty(configuration.region())) {
                throw new PopClientException("RegionId is empty, please set a valid RegionId", new RuntimeException("RegionId is empty, please set a valid RegionId"));
            }
            configuration.setEndpoint(String.format("%s%s.%s.aliyuncs.com", request.product(), endpointType, configuration.region()));
        } else {
            configuration.setEndpoint(String.format("%s%s.aliyuncs.com", request.product(), endpointType));
        }
        return configuration;
    }
}
