/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.gateway.pop.auth.signer;

import com.aliyun.auth.signature.exception.SignatureException;
import com.aliyun.auth.signature.signer.SignAlgorithmHmacSHA256;
import com.aliyun.auth.signature.signer.SignAlgorithmHmacSM3;
import com.aliyun.sdk.gateway.pop.auth.SignatureAlgorithm;
import com.aliyun.sdk.gateway.pop.auth.SignatureVersion;
import com.aliyun.sdk.gateway.pop.auth.signer.PopSigner;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class PopV4Signer
implements PopSigner {
    private final String ENCODING = "UTF-8";
    private final String HASH_SHA256 = "SHA-256";
    private final String HASH_SM3 = "SM3";
    private final String PEM_BEGIN = "-----BEGIN RSA PRIVATE KEY-----\n";
    private final String PEM_END = "\n-----END RSA PRIVATE KEY-----";
    private final SignatureAlgorithm DEFAULT_ALGORITHM;
    private final SignatureAlgorithm algorithm;

    public PopV4Signer() {
        this.algorithm = this.DEFAULT_ALGORITHM = SignatureAlgorithm.ACS3_HMAC_SHA256;
    }

    public PopV4Signer(SignatureAlgorithm algorithm) {
        this.DEFAULT_ALGORITHM = SignatureAlgorithm.ACS3_HMAC_SHA256;
        this.algorithm = algorithm != null ? algorithm : this.DEFAULT_ALGORITHM;
    }

    @Override
    public byte[] signString(String stringToSign, byte[] signingKey) {
        try {
            switch (this.algorithm) {
                case ACS4_HMAC_SM3: {
                    HMac sm3HMAC = SignAlgorithmHmacSM3.HMAC_SM3.getMac();
                    SecretKeySpec key = new SecretKeySpec(signingKey, SignAlgorithmHmacSM3.HMAC_SM3.toString());
                    byte[] sm3Sign = new byte[sm3HMAC.getMacSize()];
                    byte[] inputBytes = stringToSign.getBytes("UTF-8");
                    sm3HMAC.init((CipherParameters)new KeyParameter(key.getEncoded()));
                    sm3HMAC.update(inputBytes, 0, inputBytes.length);
                    sm3HMAC.doFinal(sm3Sign, 0);
                    return sm3Sign;
                }
            }
            Mac sha256HMAC = SignAlgorithmHmacSHA256.HmacSHA256.getMac();
            sha256HMAC.init(new SecretKeySpec(signingKey, SignAlgorithmHmacSHA256.HmacSHA256.toString()));
            return sha256HMAC.doFinal(stringToSign.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException | InvalidKeyException e) {
            throw new SignatureException(e.toString());
        }
    }

    @Override
    public byte[] signString(String stringToSign, String signingKey) {
        try {
            return this.signString(stringToSign, signingKey.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SignatureException(e.toString());
        }
    }

    @Override
    public byte[] hash(byte[] raw) {
        if (null == raw) {
            return null;
        }
        try {
            MessageDigest digest;
            switch (this.algorithm) {
                case ACS3_HMAC_SM3: {
                    BouncyCastleProvider provider = new BouncyCastleProvider();
                    digest = MessageDigest.getInstance("SM3", (Provider)provider);
                    break;
                }
                default: {
                    digest = MessageDigest.getInstance("SHA-256");
                }
            }
            return digest.digest(raw);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SignatureException(e.toString());
        }
    }

    @Override
    public String getContent() {
        switch (this.algorithm) {
            case ACS4_HMAC_SM3: {
                return "x-acs-content-sm3";
            }
        }
        return "x-acs-content-sha256";
    }

    @Override
    public SignatureAlgorithm getSignerName() {
        return this.algorithm;
    }

    @Override
    public SignatureVersion getSignerVersion() {
        return SignatureVersion.V4;
    }
}

