/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.gateway.pop.interceptor.response;

import com.aliyun.core.http.HttpResponse;
import com.aliyun.core.logging.ClientLogger;
import com.aliyun.core.utils.AttributeMap;
import com.aliyun.core.utils.BaseUtils;
import com.aliyun.core.utils.ParseUtil;
import com.aliyun.core.utils.StringUtils;
import com.aliyun.sdk.gateway.pop.exception.PopClientException;
import com.aliyun.sdk.gateway.pop.exception.PopServerException;
import com.aliyun.sdk.gateway.pop.interceptor.response.PopResInterceptor;
import darabonba.core.RequestStyle;
import darabonba.core.TeaRequest;
import darabonba.core.TeaResponse;
import darabonba.core.interceptor.InterceptorContext;
import darabonba.core.interceptor.ResponseInterceptor;
import darabonba.core.sse.Event;
import darabonba.core.sse.SSEHttpResponseHandler;
import darabonba.core.utils.CommonUtil;
import java.util.HashMap;
import java.util.Map;

public class TeaResponseInterceptor
implements ResponseInterceptor {
    private final ClientLogger logger = new ClientLogger(PopResInterceptor.class);

    public TeaResponse modifyResponse(InterceptorContext context, AttributeMap attributes) {
        this.logger.verbose("HttpResponse process begin.");
        HttpResponse httpResponse = context.httpResponse();
        TeaRequest request = context.teaRequest();
        TeaResponse teaResponse = new TeaResponse();
        teaResponse.setHttpResponse(httpResponse);
        teaResponse.setSuccess(CommonUtil.is2xx((Number)httpResponse.getStatusCode()));
        if (CommonUtil.isNot2xx((Number)httpResponse.getStatusCode())) {
            HashMap<String, Object> errMsg = new HashMap<String, Object>();
            errMsg.put("statusCode", httpResponse.getStatusCode());
            if (context.httpResponseHandler() != null && request.style().equals((Object)RequestStyle.SSE)) {
                String bodyStr = BaseUtils.bomAwareToString((byte[])((SSEHttpResponseHandler)context.httpResponseHandler()).getErrorBodyByteArrayUnsafe(), null);
                if ("text/event-stream".equals(httpResponse.getHeaderValue("content-type"))) {
                    Event errorEvent = Event.parse((String)bodyStr);
                    if ("error".equals(errorEvent.getEvent()) && !StringUtils.isEmpty((CharSequence)errorEvent.getData())) {
                        Object _body = ParseUtil.readAsJSON((String)errorEvent.getData());
                        Map err = CommonUtil.assertAsMap((Object)_body);
                        errMsg.put("code", err.get("errorName"));
                        errMsg.put("message", "code: " + err.get("errorCode") + ", " + err.get("errorMessage") + " request id: " + err.get("requestId"));
                        errMsg.put("description", err.get("errorMessage"));
                        errMsg.put("data", err);
                    } else {
                        String requestId = httpResponse.getHeaderValue("x-acs-request-id");
                        HashMap<String, String> err = new HashMap<String, String>();
                        err.put("RequestId", requestId);
                        errMsg.put("code", httpResponse.getStatusCode());
                        errMsg.put("message", bodyStr);
                        errMsg.put("description", "Not SSE style.");
                        errMsg.put("data", err);
                    }
                } else {
                    Object _body = ParseUtil.readAsJSON((String)bodyStr);
                    Map err = CommonUtil.assertAsMap((Object)_body);
                    Object requestId = CommonUtil.defaultAny(err.get("RequestId"), err.get("requestId"));
                    errMsg.put("code", CommonUtil.defaultAny(err.get("Code"), err.get("code")));
                    errMsg.put("message", "code: " + httpResponse.getStatusCode() + ", " + CommonUtil.defaultAny(err.get("Message"), err.get("message")) + " request id: " + requestId);
                    errMsg.put("description", CommonUtil.defaultAny(err.get("Description"), err.get("description")));
                    errMsg.put("accessDeniedDetail", CommonUtil.defaultAny(err.get("AccessDeniedDetail"), err.get("accessDeniedDetail")));
                    errMsg.put("data", err);
                }
            } else if (!StringUtils.isEmpty((CharSequence)httpResponse.getBodyAsString())) {
                Object _body = ParseUtil.readAsJSON((String)httpResponse.getBodyAsString());
                Map err = CommonUtil.assertAsMap((Object)_body);
                Object requestId = CommonUtil.defaultAny(err.get("RequestId"), err.get("requestId"));
                errMsg.put("code", CommonUtil.defaultAny(err.get("Code"), err.get("code")));
                errMsg.put("message", "code: " + httpResponse.getStatusCode() + ", " + CommonUtil.defaultAny(err.get("Message"), err.get("message")) + " request id: " + requestId);
                errMsg.put("description", CommonUtil.defaultAny(err.get("Description"), err.get("description")));
                errMsg.put("accessDeniedDetail", CommonUtil.defaultAny(err.get("AccessDeniedDetail"), err.get("accessDeniedDetail")));
                errMsg.put("data", err);
            } else {
                String requestId = httpResponse.getHeaderValue("x-acs-request-id");
                errMsg.put("code", httpResponse.getStatusCode());
                errMsg.put("message", "code: " + httpResponse.getStatusCode() + ", request id: " + requestId);
                errMsg.put("description", "");
            }
            teaResponse.setException((Exception)(CommonUtil.is5xx((Number)httpResponse.getStatusCode()) ? new PopServerException(errMsg) : new PopClientException(errMsg)));
        }
        return teaResponse;
    }
}

