package com.aliyun.httpcomponent.httpclient.implementation;

import java.net.InetSocketAddress;
import java.util.regex.Pattern;

import com.aliyun.core.utils.StringUtils;
import org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import org.apache.hc.client5.http.impl.routing.DefaultRoutePlanner;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.protocol.HttpContext;

/**
 * SdkProxyRoutePlanner delegates a Proxy Route Planner from the settings instead of the
 * system properties. It will use the proxy created from proxyHost and proxyPort and
 * filter the hosts who matches nonProxyHosts pattern.
 */
public class SdkProxyRoutePlanner extends DefaultRoutePlanner {

    private HttpHost proxy;
    private final Pattern nonProxyHostsPattern;

    public SdkProxyRoutePlanner(String scheme, InetSocketAddress proxySocketAddress, String nonProxyHosts) {
        super(DefaultSchemePortResolver.INSTANCE);
        proxy = new HttpHost(scheme, proxySocketAddress.getAddress(), proxySocketAddress.getHostString(),  proxySocketAddress.getPort());
        this.nonProxyHostsPattern = StringUtils.isEmpty(nonProxyHosts)
                ? null
                : Pattern.compile(nonProxyHosts, Pattern.CASE_INSENSITIVE);
    }

    private boolean doesTargetMatchNonProxyHosts(HttpHost target) {
        if (nonProxyHostsPattern == null) {
            return false;
        }
        return nonProxyHostsPattern.matcher(target.getHostName()).matches();
    }

    @Override
    protected HttpHost determineProxy(
            final HttpHost target,
            final HttpContext context) throws HttpException {

        return doesTargetMatchNonProxyHosts(target) ? null : proxy;
    }
}