package com.aliyun.httpcomponent.httpclient.implementation.reactive;

import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.util.Args;

import java.util.Iterator;

public class ReactiveApacheHttpResponse extends BasicHttpResponse {

    private com.aliyun.core.http.HttpHeaders sdkHttpHeaders;

    public ReactiveApacheHttpResponse(int code) {
        super(code);
    }

    public ReactiveApacheHttpResponse(int code, String reasonPhrase) {
        super(code, reasonPhrase);
    }

    public static ReactiveApacheHttpResponse copy(HttpResponse original) {
        Args.notNull(original, "HTTP response");
        ReactiveApacheHttpResponse copy = new ReactiveApacheHttpResponse(original.getCode());
        copy.setVersion(original.getVersion());
        Iterator it = original.headerIterator();

        while(it.hasNext()) {
            copy.addHeader((Header)it.next());
        }

        return copy;
    }

    public static ReactiveApacheHttpResponse copyLite(HttpResponse original, com.aliyun.core.http.HttpHeaders httpHeaders) {
        Args.notNull(original, "HTTP response");
        Args.notNull(httpHeaders, "com.aliyun.core.http httpHeaders");
        ReactiveApacheHttpResponse copy = new ReactiveApacheHttpResponse(original.getCode());
        copy.setVersion(original.getVersion());
        copy.setSDKHttpHeaders(httpHeaders);
        return copy;
    }

    public static ReactiveApacheHttpResponse create(int code) {
        return new ReactiveApacheHttpResponse(code);
    }

    public com.aliyun.core.http.HttpHeaders getSDKHttpHeaders() {
        return sdkHttpHeaders;
    }

    public void setSDKHttpHeaders(com.aliyun.core.http.HttpHeaders sdkHttpHeaders) {
        this.sdkHttpHeaders = sdkHttpHeaders;
    }
}
