package com.aliyun.auth.credentials.utils;

import com.aliyun.auth.credentials.exception.*;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class AuthUtils {
    private static volatile String privateKey;

    public static String getPrivateKey(String filePath) {
        FileInputStream in = null;
        byte[] buffer;
        try {
            in = new FileInputStream(new File(filePath));
            buffer = new byte[in.available()];
            in.read(buffer);
            privateKey = new String(buffer, "UTF-8");
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (in != null) {
                try {
                    in.close();
                } catch (IOException e) {
                    throw new CredentialException(e.getMessage(), e);
                }
            }
        }
        return privateKey;
    }

    public static void setPrivateKey(String key) {
        privateKey = key;
    }

}
