package com.aliyun.auth.signature.signer;

import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.macs.HMac;

public enum SignAlgorithmHmacSM3 {
    HMAC_SM3("HMAC-SM3");

    private final ThreadLocal<HMac> reference;
    private final String algorithmName;

    SignAlgorithmHmacSM3(String algorithmName) {
        this.algorithmName = algorithmName;
        reference = new MacThreadLocal();
    }

    public String getAlgorithmName(){
        return this.algorithmName;
    }

    @Override
    public String toString(){
        return this.algorithmName;
    }

    public HMac getMac() {
        return reference.get();
    }

    private static class MacThreadLocal extends ThreadLocal<HMac> {

        @Override
        protected HMac initialValue() {
            return new HMac(new SM3Digest());
        }
    }
}
