package com.aliyun.auth.credentials.provider;

import com.aliyun.auth.credentials.Credential;
import com.aliyun.auth.credentials.ICredential;
import com.aliyun.auth.credentials.exception.*;
import com.aliyun.core.utils.StringUtils;

import java.util.HashMap;

public class AnonymousCredentialProvider implements ICredentialProvider {
    private AnonymousCredentialProvider() {
    }

    public static AnonymousCredentialProvider create() {
        return new AnonymousCredentialProvider();
    }

    @Override
    public ICredential getCredentials() throws CredentialException {
        return Credential.ANONYMOUS_CREDENTIALS;
    }

    @Override
    public void close() {
    }

    @Override
    public String toString() {
        return StringUtils.toAliString("AnonymousCredentialsProvider", new HashMap<>());
    }
}
