/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.auth.credentials.provider;

import com.aliyun.auth.credentials.Credential;
import com.aliyun.auth.credentials.ICredential;
import com.aliyun.auth.credentials.exception.CredentialException;
import com.aliyun.auth.credentials.http.CompatibleUrlConnClient;
import com.aliyun.auth.credentials.http.HttpRequest;
import com.aliyun.auth.credentials.http.HttpResponse;
import com.aliyun.auth.credentials.http.MethodType;
import com.aliyun.auth.credentials.provider.HttpCredentialProvider;
import com.aliyun.auth.credentials.provider.ICredentialProvider;
import com.aliyun.auth.credentials.provider.StaticCredentialProvider;
import com.aliyun.auth.credentials.utils.AuthUtils;
import com.aliyun.auth.credentials.utils.ParameterHelper;
import com.aliyun.auth.credentials.utils.RefreshResult;
import com.aliyun.core.utils.StringUtils;
import com.aliyun.core.utils.Validate;
import com.google.gson.Gson;
import java.time.Instant;
import java.util.Map;

public final class RamRoleArnCredentialProvider
extends HttpCredentialProvider {
    private int durationSeconds;
    private String roleArn;
    private final String roleSessionName;
    private String policy;
    private String externalId;
    private int connectionTimeout;
    private int readTimeout;
    private final ICredentialProvider credentialsProvider;
    private final String stsEndpoint;
    private final CompatibleUrlConnClient client;
    private String protocol = "https";

    private RamRoleArnCredentialProvider(BuilderImpl builder) {
        super(builder);
        this.roleSessionName = builder.roleSessionName == null ? (!StringUtils.isEmpty((CharSequence)AuthUtils.getEnvironmentRoleSessionName()) ? AuthUtils.getEnvironmentRoleSessionName() : "aliyun-java-auth-" + System.currentTimeMillis()) : builder.roleSessionName;
        int n = this.durationSeconds = builder.durationSeconds == null ? 3600 : builder.durationSeconds;
        if (this.durationSeconds < 900) {
            throw new IllegalArgumentException("Session duration should be in the range of 900s - max session duration.");
        }
        String string = this.roleArn = builder.roleArn == null ? AuthUtils.getEnvironmentRoleArn() : builder.roleArn;
        if (StringUtils.isEmpty((CharSequence)this.roleArn)) {
            throw new IllegalArgumentException("RoleArn or environment variable ALIBABA_CLOUD_ROLE_ARN cannot be empty.");
        }
        this.policy = builder.policy;
        this.externalId = builder.externalId;
        this.connectionTimeout = builder.connectionTimeout == null ? 5000 : builder.connectionTimeout;
        int n2 = this.readTimeout = builder.readTimeout == null ? 10000 : builder.readTimeout;
        if (!StringUtils.isEmpty((CharSequence)builder.stsEndpoint)) {
            this.stsEndpoint = builder.stsEndpoint;
        } else {
            String prefix;
            String string2 = builder.enableVpc != null ? (builder.enableVpc.booleanValue() ? "sts-vpc" : "sts") : (prefix = AuthUtils.isEnableVpcEndpoint() ? "sts-vpc" : "sts");
            this.stsEndpoint = !StringUtils.isEmpty((CharSequence)builder.stsRegionId) ? String.format("%s.%s.aliyuncs.com", prefix, builder.stsRegionId) : (!StringUtils.isEmpty((CharSequence)AuthUtils.getEnvironmentSTSRegion()) ? String.format("%s.%s.aliyuncs.com", prefix, AuthUtils.getEnvironmentSTSRegion()) : "sts.aliyuncs.com");
        }
        if (null != builder.credentialsProvider) {
            this.credentialsProvider = builder.credentialsProvider;
        } else {
            Validate.notNull((Object)builder.credential, (String)"Credentials must not be null.", (Object[])new Object[0]);
            this.credentialsProvider = StaticCredentialProvider.create(builder.credential);
        }
        this.client = new CompatibleUrlConnClient();
        this.buildRefreshCache();
    }

    public static RamRoleArnCredentialProvider create(Credential credential) {
        return RamRoleArnCredentialProvider.builder().credential(credential).build();
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public String getStsEndpoint() {
        return this.stsEndpoint;
    }

    @Override
    public RefreshResult<ICredential> refreshCredentials() {
        HttpResponse httpResponse;
        ParameterHelper parameterHelper = new ParameterHelper();
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrlParameter("Action", "AssumeRole");
        httpRequest.setUrlParameter("Format", "JSON");
        httpRequest.setUrlParameter("Version", "2015-04-01");
        httpRequest.setUrlParameter("DurationSeconds", String.valueOf(this.durationSeconds));
        httpRequest.setUrlParameter("RoleArn", this.roleArn);
        httpRequest.setUrlParameter("RoleSessionName", this.roleSessionName);
        if (this.policy != null) {
            httpRequest.setUrlParameter("Policy", this.policy);
        }
        if (this.externalId != null) {
            httpRequest.setUrlParameter("ExternalId", this.externalId);
        }
        httpRequest.setSysMethod(MethodType.GET);
        httpRequest.setSysConnectTimeout(this.connectionTimeout);
        httpRequest.setSysReadTimeout(this.readTimeout);
        ICredential credentials = this.credentialsProvider.getCredentials();
        Validate.notNull((Object)credentials, (String)"Unable to load original credentials from the providers in RAM role arn.", (Object[])new Object[0]);
        httpRequest.setUrlParameter("AccessKeyId", credentials.accessKeyId());
        if (!StringUtils.isEmpty((CharSequence)credentials.securityToken())) {
            httpRequest.setUrlParameter("SecurityToken", credentials.securityToken());
        }
        String strToSign = parameterHelper.composeStringToSign(MethodType.GET, httpRequest.getUrlParameters());
        String signature = parameterHelper.signString(strToSign, credentials.accessKeySecret() + "&");
        httpRequest.setUrlParameter("Signature", signature);
        httpRequest.setSysUrl(parameterHelper.composeUrl(this.stsEndpoint, httpRequest.getUrlParameters(), this.protocol));
        try {
            httpResponse = this.client.syncInvoke(httpRequest);
        }
        catch (Exception e) {
            throw new CredentialException("Failed to connect RamRoleArn Service: " + e);
        }
        if (httpResponse.getResponseCode() != 200) {
            throw new CredentialException(String.format("Error refreshing credentials from RamRoleArn, HttpCode: %s, result: %s.", httpResponse.getResponseCode(), httpResponse.getHttpContentString()));
        }
        Gson gson = new Gson();
        Map map = (Map)gson.fromJson(httpResponse.getHttpContentString(), Map.class);
        if (null == map || !map.containsKey("Credentials")) {
            throw new CredentialException(String.format("Error retrieving credentials from RamRoleArn result: %s.", httpResponse.getHttpContentString()));
        }
        Map result = (Map)map.get("Credentials");
        if (!(result.containsKey("AccessKeyId") && result.containsKey("AccessKeySecret") && result.containsKey("SecurityToken"))) {
            throw new CredentialException(String.format("Error retrieving credentials from RamRoleArn result: %s.", httpResponse.getHttpContentString()));
        }
        Instant expiration = ParameterHelper.getUTCDate((String)result.get("Expiration")).toInstant();
        Credential credential = Credential.builder().accessKeyId((String)result.get("AccessKeyId")).accessKeySecret((String)result.get("AccessKeySecret")).securityToken((String)result.get("SecurityToken")).build();
        return RefreshResult.builder(credential).staleTime(this.getStaleTime(expiration)).prefetchTime(this.getPrefetchTime(expiration)).build();
    }

    @Override
    public void close() {
        super.close();
        this.client.close();
    }

    private static final class BuilderImpl
    extends HttpCredentialProvider.BuilderImpl<RamRoleArnCredentialProvider, Builder>
    implements Builder {
        private String roleSessionName;
        private Integer durationSeconds;
        private String roleArn;
        private String regionId;
        private String policy;
        private Integer connectionTimeout;
        private Integer readTimeout;
        private Credential credential;
        private String stsEndpoint;
        private String stsRegionId;
        private Boolean enableVpc;
        private ICredentialProvider credentialsProvider;
        private String externalId;

        private BuilderImpl() {
        }

        @Override
        public Builder roleSessionName(String roleSessionName) {
            this.roleSessionName = roleSessionName;
            return this;
        }

        @Override
        public Builder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        @Override
        public Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder regionId(String regionId) {
            this.regionId = regionId;
            return this;
        }

        @Override
        public Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        @Override
        public Builder connectionTimeout(Integer connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        @Override
        public Builder readTimeout(Integer readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        @Override
        public Builder credential(Credential credential) {
            this.credential = credential;
            return this;
        }

        @Override
        public Builder credentialsProvider(ICredentialProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        @Override
        public Builder stsEndpoint(String stsEndpoint) {
            this.stsEndpoint = stsEndpoint;
            return this;
        }

        @Override
        public Builder stsRegionId(String stsRegionId) {
            this.stsRegionId = stsRegionId;
            return this;
        }

        @Override
        public Builder enableVpc(Boolean enableVpc) {
            this.enableVpc = enableVpc;
            return this;
        }

        @Override
        public Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        @Override
        public RamRoleArnCredentialProvider build() {
            return new RamRoleArnCredentialProvider(this);
        }
    }

    public static interface Builder
    extends HttpCredentialProvider.Builder<RamRoleArnCredentialProvider, Builder> {
        public Builder roleSessionName(String var1);

        public Builder durationSeconds(Integer var1);

        public Builder roleArn(String var1);

        public Builder regionId(String var1);

        public Builder policy(String var1);

        public Builder connectionTimeout(Integer var1);

        public Builder readTimeout(Integer var1);

        public Builder credential(Credential var1);

        public Builder credentialsProvider(ICredentialProvider var1);

        public Builder stsEndpoint(String var1);

        public Builder stsRegionId(String var1);

        public Builder enableVpc(Boolean var1);

        public Builder externalId(String var1);

        @Override
        public RamRoleArnCredentialProvider build();
    }
}

