/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.auth.credentials.utils;

import com.aliyun.core.logging.ClientLogger;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class ProfileUtils {
    private static final ClientLogger logger = new ClientLogger(ProfileUtils.class);
    private static final Pattern EMPTY_LINE = Pattern.compile("^[\t ]*$");

    public static Map<String, Map<String, String>> parseFile(String profilePath) throws IOException {
        return ProfileUtils.parseFile(new FileReader(profilePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, Map<String, String>> parseFile(Reader input) throws IOException {
        ParserProgress progress = new ParserProgress();
        try (BufferedReader profileReader = null;){
            String line;
            profileReader = new BufferedReader(input);
            while ((line = profileReader.readLine()) != null) {
                ProfileUtils.parseLine(progress, line);
            }
        }
        return progress.profiles;
    }

    private static void parseLine(ParserProgress progress, String line) {
        ++progress.currentLineNumber;
        if (!(EMPTY_LINE.matcher(line).matches() || line.startsWith("#") || line.startsWith(";"))) {
            if (ProfileUtils.isSectionDefinitionLine(line)) {
                ProfileUtils.readSectionDefinitionLine(progress, line);
            } else if (line.startsWith("\t")) {
                ProfileUtils.readPropertyContinuationLine(progress, line);
            } else {
                ProfileUtils.readPropertyDefinitionLine(progress, line);
            }
        }
    }

    private static void readSectionDefinitionLine(ParserProgress progress, String line) {
        String lineWithoutComments = ProfileUtils.removeTrailingComments(line, "#", ";");
        String lineWithoutWhitespace = lineWithoutComments.trim();
        if (!lineWithoutWhitespace.endsWith("]")) {
            throw new IllegalArgumentException(String.format("Section definition must end with ']' on line %s: %s", progress.currentLineNumber, line));
        }
        String lineWithoutBrackets = lineWithoutWhitespace.substring(1, lineWithoutWhitespace.length() - 1);
        String profileName = lineWithoutBrackets.trim();
        if (profileName.isEmpty()) {
            progress.ignoringCurrentProfile = true;
            return;
        }
        progress.currentProfileBeingRead = profileName;
        progress.currentPropertyBeingRead = null;
        progress.ignoringCurrentProfile = false;
        if (!progress.profiles.containsKey(profileName)) {
            progress.profiles.put(profileName, new LinkedHashMap());
        }
    }

    private static void readPropertyDefinitionLine(ParserProgress progress, String line) {
        if (progress.ignoringCurrentProfile) {
            return;
        }
        if (progress.currentProfileBeingRead == null) {
            progress.currentProfileBeingRead = "?";
            if (!progress.profiles.containsKey(progress.currentProfileBeingRead)) {
                progress.profiles.put(progress.currentProfileBeingRead, new LinkedHashMap());
            }
        }
        String lineWithoutComments = ProfileUtils.removeTrailingComments(line, " #", " ;", "\t#", "\t;");
        String lineWithoutWhitespace = lineWithoutComments.trim();
        Property<String, String> property = ProfileUtils.parsePropertyDefinition(progress, lineWithoutWhitespace);
        if (((Map)progress.profiles.get(progress.currentProfileBeingRead)).containsKey(property.key())) {
            logger.warning("Duplicate property '" + property.key() + "' detected on line " + progress.currentLineNumber + ". The later one in the file will be used.");
        }
        progress.currentPropertyBeingRead = property.key();
        ((Map)progress.profiles.get(progress.currentProfileBeingRead)).put(property.key(), property.value());
    }

    private static void readPropertyContinuationLine(ParserProgress progress, String line) {
        if (progress.ignoringCurrentProfile) {
            return;
        }
        if (progress.currentProfileBeingRead == null) {
            progress.currentProfileBeingRead = "?";
            if (!progress.profiles.containsKey(progress.currentProfileBeingRead)) {
                progress.profiles.put(progress.currentProfileBeingRead, new LinkedHashMap());
            }
        }
        line = line.trim();
        Map profileProperties = (Map)progress.profiles.get(progress.currentProfileBeingRead);
        String currentPropertyValue = (String)profileProperties.get(progress.currentPropertyBeingRead);
        String newPropertyValue = currentPropertyValue + "\n" + line;
        profileProperties.put(progress.currentPropertyBeingRead, newPropertyValue);
    }

    private static Property<String, String> parsePropertyDefinition(ParserProgress progress, String line) {
        int firstEqualsLocation = line.indexOf(61);
        String propertyKey = null;
        String propertyValue = null;
        if (firstEqualsLocation == -1) {
            propertyKey = line.trim();
        } else {
            propertyKey = line.substring(0, firstEqualsLocation).trim();
            propertyValue = line.substring(firstEqualsLocation + 1).trim();
        }
        if (propertyKey.isEmpty()) {
            throw new IllegalArgumentException(String.format("Property did not have a name on line %s", progress.currentLineNumber));
        }
        return new Property<String, String>(propertyKey, propertyValue);
    }

    private static boolean isSectionDefinitionLine(String line) {
        return line.trim().startsWith("[");
    }

    private static String removeTrailingComments(String line, String ... commentPatterns) {
        int earliestMatchIndex = line.length();
        for (String pattern : commentPatterns) {
            int index = line.indexOf(pattern);
            if (index < 0 || index >= earliestMatchIndex) continue;
            earliestMatchIndex = index;
        }
        return line.substring(0, earliestMatchIndex);
    }

    private static final class Property<Key, Value> {
        private final Key key;
        private final Value value;

        private Property(Key key, Value value) {
            this.key = key;
            this.value = value;
        }

        public Key key() {
            return this.key;
        }

        public Value value() {
            return this.value;
        }
    }

    private static final class ParserProgress {
        private int currentLineNumber = 0;
        private String currentProfileBeingRead = null;
        private String currentPropertyBeingRead = null;
        private boolean ignoringCurrentProfile = false;
        private final Map<String, Map<String, String>> profiles = new LinkedHashMap<String, Map<String, String>>();

        private ParserProgress() {
        }
    }
}

