package com.aliyun.core.utils;

import com.aliyun.core.logging.ClientLogger;
import com.aliyun.core.http.Header;

import java.util.Collections;

public class ClientOptions {
    private static final int MAX_APPLICATION_ID_LENGTH = 24;
    private static final String INVALID_APPLICATION_ID_LENGTH = "'productId' length cannot be greater than "
        + MAX_APPLICATION_ID_LENGTH;
    private static final String INVALID_APPLICATION_ID_SPACE = "'productId' cannot contain spaces.";

    private final ClientLogger logger = new ClientLogger(ClientOptions.class);
    private Iterable<Header> headers;

    private String productId;
    
    public String getProductId() {
        return productId;
    }
    
    public ClientOptions setProductId(String productId) {
        if (StringUtils.isEmpty(productId)) {
            this.productId = productId;
        } else if (productId.length() > MAX_APPLICATION_ID_LENGTH) {
            throw logger.logExceptionAsError(new IllegalArgumentException(INVALID_APPLICATION_ID_LENGTH));
        } else if (productId.contains(" ")) {
            throw logger.logExceptionAsError(new IllegalArgumentException(INVALID_APPLICATION_ID_SPACE));
        } else {
            this.productId = productId;
        }

        return this;
    }
    
    public ClientOptions setHeaders(Iterable<Header> headers) {
        this.headers = headers;
        return this;
    }

    public Iterable<Header> getHeaders() {
        if (headers == null) {
            return Collections.emptyList();
        }
        return headers;
    }
}
