package com.aliyun.core.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MapUtils {
    /**
     * concat two same map to new one
     *
     * @param m1 first map
     * @param m2 second map
     * @return
     */
    public static <T> Map<String, T> concat(Map<String, T> m1, Map<String, T> m2) {
        Map<String, T> newMap = new HashMap<>();
        newMap.putAll(m1);
        newMap.putAll(m2);
        return newMap;
    }

    public static <T> Map<String, T> merge(Class<T> t, Map<String, ?>... maps) {
        Map<String, T> out = new HashMap<String, T>();
        for (int i = 0; i < maps.length; i++) {
            Map<String, ?> map = maps[i];
            if (null == map) {
                continue;
            }
            Set<? extends Map.Entry<String, ?>> entries = map.entrySet();
            for (Map.Entry<String, ?> entry : entries) {
                if (null != entry.getValue()) {
                    out.put(entry.getKey(), (T) entry.getValue());
                }
            }
        }
        return out;
    }
}
